/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandler;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotHandlerType;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotWarningException;
import org.apache.ignite.internal.util.typedef.F;

public class DataStreamerUpdatesHandler
implements SnapshotHandler<Boolean> {
    public static final String WRN_MSG = "DataStreamer with property 'allowOverwrite' set to `false` was working during the snapshot creation. Such streaming updates are inconsistent by nature and should be successfully finished before data usage. Snapshot might not be entirely restored. However, you would be able to restore the caches which were not streamed into.";

    @Override
    public SnapshotHandlerType type() {
        return SnapshotHandlerType.CREATE;
    }

    @Override
    public Boolean invoke(SnapshotHandlerContext ctx) {
        return ctx.streamerWarning();
    }

    @Override
    public void complete(String name, Collection<SnapshotHandlerResult<Boolean>> results) throws SnapshotWarningException {
        Collection<UUID> nodes = F.viewReadOnly(results, r -> r.node().id(), SnapshotHandlerResult::data);
        if (!F.isEmpty(nodes)) {
            throw new SnapshotWarningException("DataStreamer with property 'allowOverwrite' set to `false` was working during the snapshot creation. Such streaming updates are inconsistent by nature and should be successfully finished before data usage. Snapshot might not be entirely restored. However, you would be able to restore the caches which were not streamed into. Updates from DataStreamer detected on the nodes: " + nodes.stream().map(UUID::toString).collect(Collectors.joining(", ")) + ".");
        }
    }
}

