/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentArchiveSizeStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentArchivedStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentCompressStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentCurrentStateStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentLockStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentReservationStorage;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentTruncateStorage;

public class SegmentAware {
    private final SegmentReservationStorage reservationStorage = new SegmentReservationStorage();
    private final SegmentLockStorage segmentLockStorage = new SegmentLockStorage();
    private final SegmentArchivedStorage segmentArchivedStorage = new SegmentArchivedStorage(this.segmentLockStorage);
    private final SegmentCompressStorage segmentCompressStorage;
    private final SegmentCurrentStateStorage segmentCurrStateStorage;
    private final SegmentArchiveSizeStorage archiveSizeStorage;
    private final SegmentTruncateStorage truncateStorage;

    public SegmentAware(IgniteLogger log, int walSegmentsCnt, boolean compactionEnabled, long minWalArchiveSize, long maxWalArchiveSize) {
        this.segmentCurrStateStorage = new SegmentCurrentStateStorage(walSegmentsCnt);
        this.segmentCompressStorage = new SegmentCompressStorage(log, compactionEnabled);
        this.archiveSizeStorage = new SegmentArchiveSizeStorage(log, minWalArchiveSize, maxWalArchiveSize, this.reservationStorage);
        this.truncateStorage = new SegmentTruncateStorage();
        this.segmentArchivedStorage.addObserver(this.segmentCurrStateStorage::onSegmentArchived);
        this.segmentArchivedStorage.addObserver(this.segmentCompressStorage::onSegmentArchived);
        this.segmentArchivedStorage.addObserver(this.truncateStorage::lastArchivedIdx);
        this.segmentLockStorage.addObserver(this.segmentArchivedStorage::onSegmentUnlocked);
        this.reservationStorage.addObserver(this.truncateStorage::minReservedIdx);
    }

    public void awaitSegment(long absSegIdx) throws IgniteInterruptedCheckedException {
        this.segmentCurrStateStorage.awaitSegment(absSegIdx);
    }

    public long nextAbsoluteSegmentIndex() throws IgniteInterruptedCheckedException {
        return this.segmentCurrStateStorage.nextAbsoluteSegmentIndex();
    }

    public long curAbsWalIdx() {
        return this.segmentCurrStateStorage.curAbsWalIdx();
    }

    public long waitNextSegmentForArchivation() throws IgniteInterruptedCheckedException {
        return this.segmentCurrStateStorage.waitNextSegmentForArchivation();
    }

    public void markAsMovedToArchive(long toArchive) throws IgniteInterruptedCheckedException {
        this.segmentArchivedStorage.markAsMovedToArchive(toArchive);
    }

    public void awaitSegmentArchived(long awaitIdx) throws IgniteInterruptedCheckedException {
        this.segmentArchivedStorage.awaitSegmentArchived(awaitIdx);
    }

    public void awaitSegmentCompressed(long awaitIdx) throws IgniteInterruptedCheckedException {
        this.segmentCompressStorage.awaitSegmentCompressed(awaitIdx);
    }

    public long waitNextSegmentToCompress() throws IgniteInterruptedCheckedException {
        long idx;
        while ((idx = this.segmentCompressStorage.nextSegmentToCompressOrWait()) <= this.lastTruncatedArchiveIdx()) {
            this.onSegmentCompressed(idx);
        }
        return idx;
    }

    public void onSegmentCompressed(long compressedIdx) {
        this.segmentCompressStorage.onSegmentCompressed(compressedIdx);
    }

    public long lastCompressedIdx() {
        return this.segmentCompressStorage.lastCompressedIdx();
    }

    public void curAbsWalIdx(long curAbsWalIdx) {
        this.segmentCurrStateStorage.curAbsWalIdx(curAbsWalIdx);
    }

    public void lastTruncatedArchiveIdx(long absIdx) {
        this.truncateStorage.lastTruncatedIdx(absIdx);
    }

    public long lastTruncatedArchiveIdx() {
        return this.truncateStorage.lastTruncatedIdx();
    }

    public void setLastArchivedAbsoluteIndex(long lastAbsArchivedIdx) {
        this.segmentArchivedStorage.setLastArchivedAbsoluteIndex(lastAbsArchivedIdx);
    }

    public long lastArchivedAbsoluteIndex() {
        return this.segmentArchivedStorage.lastArchivedAbsoluteIndex();
    }

    public boolean reserve(long absIdx) {
        return this.reservationStorage.reserve(absIdx);
    }

    public boolean reserved(long absIdx) {
        return this.reservationStorage.reserved(absIdx);
    }

    public void release(long absIdx) {
        this.reservationStorage.release(absIdx);
    }

    public boolean locked(long absIdx) {
        return this.segmentLockStorage.locked(absIdx);
    }

    public boolean lock(long absIdx) {
        return this.segmentLockStorage.lockWorkSegment(absIdx);
    }

    public void unlock(long absIdx) {
        this.segmentLockStorage.releaseWorkSegment(absIdx);
    }

    public void reset() {
        this.segmentArchivedStorage.reset();
        this.segmentCompressStorage.reset();
        this.segmentCurrStateStorage.reset();
        this.archiveSizeStorage.reset();
        this.truncateStorage.reset();
    }

    public void interrupt() {
        this.segmentArchivedStorage.interrupt();
        this.segmentCompressStorage.interrupt();
        this.segmentCurrStateStorage.interrupt();
        this.archiveSizeStorage.interrupt();
        this.truncateStorage.interrupt();
    }

    public void forceInterrupt() {
        this.segmentArchivedStorage.interrupt();
        this.segmentCompressStorage.interrupt();
        this.segmentCurrStateStorage.forceInterrupt();
        this.archiveSizeStorage.interrupt();
        this.truncateStorage.interrupt();
    }

    public boolean minReserveIndex(long absIdx) {
        return this.reservationStorage.minReserveIndex(absIdx);
    }

    public boolean minLockIndex(long absIdx) {
        return this.segmentLockStorage.minLockIndex(absIdx);
    }

    public void addSize(long idx, long sizeChange) {
        this.archiveSizeStorage.changeSize(idx, sizeChange);
    }

    public void resetWalArchiveSizes() {
        this.archiveSizeStorage.resetSizes();
    }

    public void awaitExceedMaxArchiveSize(long max) throws IgniteInterruptedCheckedException {
        this.archiveSizeStorage.awaitExceedMaxSize(max);
    }

    public void lastCheckpointIdx(long absIdx) {
        this.truncateStorage.lastCheckpointIdx(absIdx);
        this.archiveSizeStorage.lastCheckpointIdx(absIdx);
    }

    public long awaitAvailableTruncateArchive() throws IgniteInterruptedCheckedException {
        return this.truncateStorage.awaitAvailableTruncate();
    }

    public void startAutoReleaseSegments() {
        this.archiveSizeStorage.startAutoReleaseSegments();
    }
}

