/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.LongAdder;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.yardstickframework.BenchmarkUtils;

public class IntMaxValueEntriesTest
extends IgniteCacheAbstractBenchmark {
    private static final int THREADS = 16;
    private static final int KEYS_LO = -100000;
    private static final long KEYS_HI = Integer.MAX_VALUE;
    private static final int REPORT_DELTA = 1000000;
    private static final String CACHE_NAME = "int-max-value-cache";

    public boolean test(Map<Object, Object> ctx) throws Exception {
        IgniteCache cache = this.cache();
        final IgniteDataStreamer stmr = this.ignite().dataStreamer(cache.getName());
        ArrayList<Thread> threads = new ArrayList<Thread>(16);
        final LongAdder addedCnt = new LongAdder();
        int delta = (int)((Integer.MAX_VALUE + (long)Math.abs(-100000)) / 16L);
        System.out.println("Delta: " + delta);
        for (int i = 0; i < 16; ++i) {
            final int lo = i == 0 ? -100000 : delta * i + 1;
            final int hi = i == 15 ? Integer.MAX_VALUE : (int)((long)delta * (long)(i + 1));
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ThreadLocalRandom rnd = ThreadLocalRandom.current();
                    byte val = (byte)rnd.nextInt();
                    BenchmarkUtils.println((String)("Start from " + lo + " to " + hi));
                    int j = lo;
                    int k = 0;
                    while (j < hi) {
                        byte by = val;
                        val = (byte)(val + 1);
                        stmr.addData((Object)j, (Object)by);
                        addedCnt.increment();
                        if (k % 1000000 == 0) {
                            BenchmarkUtils.println((String)(addedCnt.sum() + " entries"));
                        }
                        ++j;
                        ++k;
                    }
                    BenchmarkUtils.println((String)("Thread finished. " + addedCnt.sum() + " entries."));
                }
            });
            threads.add(t);
            t.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        BenchmarkUtils.println((String)("All threads finished. " + addedCnt.sum() + " entries."));
        BenchmarkUtils.println((String)"Streamer flush");
        stmr.flush();
        BenchmarkUtils.println((String)"Streamer flushed");
        BenchmarkUtils.println((String)"Calculating cache size");
        BenchmarkUtils.println((String)("Cache size: " + cache.size(new CachePeekMode[0])));
        BenchmarkUtils.println((String)"Calculating long cache size");
        BenchmarkUtils.println((String)("Cache size long: " + cache.sizeLong(new CachePeekMode[0])));
        Thread.sleep(10000L);
        BenchmarkUtils.println((String)"Iterating started");
        long cnt = 0L;
        for (Cache.Entry ignored : cache) {
            if (++cnt <= 0L || cnt % 1000000L != 0L) continue;
            BenchmarkUtils.println((String)("Iterated via " + cnt + " entries"));
        }
        BenchmarkUtils.println((String)("Iterated via " + cnt + " entries"));
        cache.destroy();
        return true;
    }

    protected IgniteCache cache() {
        return this.ignite().cache(CACHE_NAME);
    }
}

