/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.jdbc;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.sql.engine.AsyncCursor;
import org.apache.ignite.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite.internal.sql.engine.SqlQueryType;
import org.apache.ignite.sql.ResultSetMetadata;

public class JdbcQueryCursor<T>
implements AsyncSqlCursor<T> {
    private final long maxRows;
    private final AsyncSqlCursor<T> cur;
    private final AtomicLong fetched = new AtomicLong();

    public JdbcQueryCursor(int maxRows, AsyncSqlCursor<T> cur) {
        this.maxRows = maxRows;
        this.cur = cur;
    }

    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        long fetched0 = this.fetched.addAndGet(rows);
        return this.cur.requestNextAsync(rows).thenApply(batch -> {
            if (this.maxRows == 0L || fetched0 < this.maxRows) {
                return batch;
            }
            if (fetched0 - (long)rows < this.maxRows) {
                return new AsyncCursor.BatchedResult(batch.items().subList(0, (int)(this.maxRows - fetched0 + (long)rows)), false);
            }
            return new AsyncCursor.BatchedResult(List.of(), false);
        });
    }

    public CompletableFuture<Void> closeAsync() {
        return this.cur.closeAsync();
    }

    public SqlQueryType queryType() {
        return this.cur.queryType();
    }

    public ResultSetMetadata metadata() {
        return this.cur.metadata();
    }
}

