/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.impl.PersistentTxStateVacuumizer;
import org.jetbrains.annotations.Nullable;

public class VolatileTxStateMetaStorage {
    private static final IgniteLogger LOG = Loggers.forClass(VolatileTxStateMetaStorage.class);
    private ConcurrentHashMap<UUID, TxStateMeta> txStateMap;

    public void start() {
        this.txStateMap = new ConcurrentHashMap();
    }

    public void stop() {
        this.txStateMap.clear();
    }

    public void initialize(UUID txId, UUID txCrdId) {
        TxStateMeta previous = this.txStateMap.put(txId, new TxStateMeta(TxState.PENDING, txCrdId, null, null));
        assert (previous == null) : "Transaction state has already defined [txId=" + String.valueOf(txCrdId) + ", state=" + String.valueOf((Object)previous.txState()) + "]";
    }

    @Nullable
    public <T extends TxStateMeta> T updateMeta(UUID txId, Function<@Nullable TxStateMeta, TxStateMeta> updater) {
        return (T)this.txStateMap.compute(txId, (k, oldMeta) -> {
            TxStateMeta newMeta = (TxStateMeta)updater.apply((TxStateMeta)oldMeta);
            if (newMeta == null) {
                return null;
            }
            TxState oldState = oldMeta == null ? null : oldMeta.txState();
            return TxState.checkTransitionCorrectness(oldState, newMeta.txState()) ? newMeta : oldMeta;
        });
    }

    public TxStateMeta state(UUID txId) {
        return this.txStateMap.get(txId);
    }

    public Collection<TxStateMeta> states() {
        return this.txStateMap.values();
    }

    public CompletableFuture<Void> vacuum(long vacuumObservationTimestamp, long txnResourceTtl, Function<Map<TablePartitionId, Set<PersistentTxStateVacuumizer.VacuumizableTx>>, CompletableFuture<PersistentTxStateVacuumizer.PersistentTxStateVacuumResult>> persistentVacuumOp) {
        LOG.info("Vacuum started [vacuumObservationTimestamp={}, txnResourceTtl={}].", new Object[]{vacuumObservationTimestamp, txnResourceTtl});
        AtomicInteger vacuumizedTxnsCount = new AtomicInteger(0);
        AtomicInteger markedAsInitiallyDetectedTxnsCount = new AtomicInteger(0);
        AtomicInteger alreadyMarkedTxnsCount = new AtomicInteger(0);
        AtomicInteger skippedForFurtherProcessingUnfinishedTxnsCount = new AtomicInteger(0);
        HashMap txIds = new HashMap();
        HashMap cleanupCompletionTimestamps = new HashMap();
        this.txStateMap.forEach((txId, meta) -> this.txStateMap.computeIfPresent((UUID)txId, (txId0, meta0) -> {
            if (TxState.isFinalState(meta0.txState())) {
                Long initialVacuumObservationTimestamp = meta0.initialVacuumObservationTimestamp();
                if (initialVacuumObservationTimestamp == null && txnResourceTtl > 0L) {
                    markedAsInitiallyDetectedTxnsCount.incrementAndGet();
                    return VolatileTxStateMetaStorage.markInitialVacuumObservationTimestamp(meta0, vacuumObservationTimestamp);
                }
                Long cleanupCompletionTimestamp = meta0.cleanupCompletionTimestamp();
                boolean shouldBeVacuumized = VolatileTxStateMetaStorage.shouldBeVacuumized(initialVacuumObservationTimestamp, cleanupCompletionTimestamp, txnResourceTtl, vacuumObservationTimestamp);
                if (shouldBeVacuumized) {
                    if (meta0.commitPartitionId() == null) {
                        vacuumizedTxnsCount.incrementAndGet();
                        return null;
                    }
                    Set ids = txIds.computeIfAbsent(meta0.commitPartitionId(), k -> new HashSet());
                    ids.add(new PersistentTxStateVacuumizer.VacuumizableTx((UUID)txId, cleanupCompletionTimestamp));
                    if (cleanupCompletionTimestamp != null) {
                        cleanupCompletionTimestamps.put(txId, cleanupCompletionTimestamp);
                    }
                    return meta0;
                }
                alreadyMarkedTxnsCount.incrementAndGet();
                return meta0;
            }
            skippedForFurtherProcessingUnfinishedTxnsCount.incrementAndGet();
            return meta0;
        }));
        return persistentVacuumOp.apply(txIds).thenAccept(vacuumResult -> {
            for (UUID txId : vacuumResult.txnsToVacuum) {
                this.txStateMap.compute(txId, (k, v) -> {
                    TxStateMeta newMeta;
                    if (v == null) {
                        return null;
                    }
                    Long cleanupCompletionTs = (Long)cleanupCompletionTimestamps.get(txId);
                    TxStateMeta txStateMeta = newMeta = Objects.equals(cleanupCompletionTs, v.cleanupCompletionTimestamp()) ? null : v;
                    if (newMeta == null) {
                        vacuumizedTxnsCount.incrementAndGet();
                    }
                    return newMeta;
                });
            }
            LOG.info("Vacuum finished [vacuumObservationTimestamp={}, txnResourceTtl={}, vacuumizedTxnsCount={}, vacuumizedPersistentTxnStatesCount={}, markedAsInitiallyDetectedTxnsCount={}, alreadyMarkedTxnsCount={}, skippedForFurtherProcessingUnfinishedTxnsCount={}].", new Object[]{vacuumObservationTimestamp, txnResourceTtl, vacuumizedTxnsCount, vacuumResult.vacuumizedPersistentTxnStatesCount, markedAsInitiallyDetectedTxnsCount, alreadyMarkedTxnsCount, skippedForFurtherProcessingUnfinishedTxnsCount});
        });
    }

    Map<UUID, TxStateMeta> statesMap() {
        return Collections.unmodifiableMap(this.txStateMap);
    }

    private static TxStateMeta markInitialVacuumObservationTimestamp(TxStateMeta meta, long vacuumObservationTimestamp) {
        return new TxStateMeta(meta.txState(), meta.txCoordinatorId(), meta.commitPartitionId(), meta.commitTimestamp(), vacuumObservationTimestamp, meta.cleanupCompletionTimestamp());
    }

    private static boolean shouldBeVacuumized(@Nullable Long initialVacuumObservationTimestamp, @Nullable Long cleanupCompletionTimestamp, long txnResourceTtl, long vacuumObservationTimestamp) {
        if (txnResourceTtl == 0L) {
            return true;
        }
        assert (initialVacuumObservationTimestamp != null) : "initialVacuumObservationTimestamp should have been set if txnResourceTtl > 0 [txnResourceTtl=" + txnResourceTtl + "].";
        if (cleanupCompletionTimestamp == null) {
            return initialVacuumObservationTimestamp + txnResourceTtl < vacuumObservationTimestamp;
        }
        return Math.max(cleanupCompletionTimestamp, initialVacuumObservationTimestamp) + txnResourceTtl < vacuumObservationTimestamp;
    }
}

