/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ignite.configuration.ConfigurationTree;
import org.apache.ignite.configuration.KeyIgnorer;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.SuperRootChange;
import org.apache.ignite.internal.configuration.ConfigurationChanger;
import org.apache.ignite.internal.configuration.ConfigurationMigrator;
import org.apache.ignite.internal.configuration.ConfigurationTreeGenerator;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.SuperRoot;
import org.apache.ignite.internal.configuration.SuperRootChangeImpl;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotifier;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.configuration.validation.ConfigurationValidator;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConfigurationRegistry
implements IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(ConfigurationRegistry.class);
    private final Map<String, DynamicConfiguration<?, ?>> configs = new HashMap();
    private final ConfigurationChanger changer;
    private final KeyIgnorer keyIgnorer;

    @TestOnly
    public ConfigurationRegistry(Collection<RootKey<?, ?, ?>> rootKeys, ConfigurationStorage storage, ConfigurationTreeGenerator generator, ConfigurationValidator configurationValidator) {
        this(rootKeys, storage, generator, configurationValidator, c -> {}, s -> false);
    }

    public ConfigurationRegistry(Collection<RootKey<?, ?, ?>> rootKeys, ConfigurationStorage storage, final ConfigurationTreeGenerator generator, ConfigurationValidator configurationValidator, ConfigurationMigrator migrator, KeyIgnorer keyIgnorer) {
        ConfigurationUtil.checkConfigurationType(rootKeys, storage);
        this.keyIgnorer = keyIgnorer;
        this.changer = new ConfigurationChanger(this.notificationUpdateListener(), rootKeys, storage, configurationValidator, migrator, keyIgnorer){

            @Override
            public InnerNode createRootNode(RootKey<?, ?, ?> rootKey) {
                return generator.instantiateNode(rootKey.schemaClass());
            }
        };
        rootKeys.forEach(rootKey -> {
            DynamicConfiguration<?, ?> cfg = generator.instantiateCfg((RootKey<?, ?, ?>)rootKey, this.changer);
            this.configs.put(rootKey.key(), cfg);
        });
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        this.changer.start();
        this.configs.values().forEach(ConfigurationUtil::touch);
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        this.changer.stop();
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> onDefaultsPersisted() {
        return this.changer.onDefaultsPersisted();
    }

    public void initializeConfigurationWith(ConfigurationSource configurationSource) {
        this.changer.initializeConfigurationWith(configurationSource);
    }

    public <V, C extends V, T extends ConfigurationTree<? super V, ? super C>> T getConfiguration(RootKey<T, V, C> rootKey) {
        return (T)this.configs.get(rootKey.key());
    }

    public SuperRoot superRoot() {
        return this.changer.superRoot().copy();
    }

    public CompletableFuture<Void> change(ConfigurationSource changesSrc) {
        return this.changer.change(changesSrc);
    }

    public CompletableFuture<Void> change(final Consumer<SuperRootChange> change) {
        return this.change(new ConfigurationSource(){

            @Override
            public void descend(ConstructableTreeNode node) {
                assert (node instanceof SuperRoot) : "Descending always starts with super root: " + String.valueOf(node);
                SuperRoot superRoot = (SuperRoot)node;
                change.accept(new SuperRootChangeImpl(superRoot));
            }
        });
    }

    private ConfigurationChanger.ConfigurationUpdateListener notificationUpdateListener() {
        return new ConfigurationChanger.ConfigurationUpdateListener(){

            @Override
            public CompletableFuture<Void> onConfigurationUpdated(final @Nullable SuperRoot oldSuperRoot, SuperRoot newSuperRoot, final long storageRevision, final long notificationNumber) {
                final ArrayList futures = new ArrayList();
                newSuperRoot.traverseChildren(new ConfigurationVisitor<Void>(){

                    @Override
                    public Void visitInnerNode(Field field, String key, InnerNode newRoot) {
                        InnerNode oldRoot;
                        DynamicConfiguration<?, ?> config = ConfigurationRegistry.this.configs.get(key);
                        assert (config != null) : key;
                        if (oldSuperRoot != null) {
                            oldRoot = oldSuperRoot.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                            assert (oldRoot != null) : key;
                        } else {
                            oldRoot = null;
                        }
                        futures.addAll(ConfigurationNotifier.notifyListeners(oldRoot, newRoot, config, storageRevision, notificationNumber));
                        return null;
                    }
                }, true);
                return this.combineFutures(futures);
            }

            private CompletableFuture<Void> combineFutures(Collection<CompletableFuture<?>> futures) {
                if (futures.isEmpty()) {
                    return CompletableFutures.nullCompletedFuture();
                }
                CompletableFuture[] resultFutures = (CompletableFuture[])futures.stream().map(fut -> fut.whenComplete((res, throwable) -> {
                    if (throwable != null) {
                        LOG.info("Failed to notify configuration listener", throwable);
                    }
                })).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(resultFutures);
            }
        };
    }

    public KeyIgnorer keyIgnorer() {
        return this.keyIgnorer;
    }

    public long notificationCount() {
        return this.changer.notificationCount();
    }
}

