/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.util;

import java.time.Year;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.ignite.internal.lang.IgniteStringBuilder;
import org.apache.ignite.internal.sql.engine.exec.exp.IgniteSqlFunctions;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlDateTimeUtils {
    private static final Pattern TIME_PATTERN = Pattern.compile("^(\\d+):(\\d+):(\\d+)(\\.\\d*)?$");
    private static final Pattern DATE_PATTERN = Pattern.compile("^(\\d{4})-([0]\\d|1[0-2])-([0-2]\\d|3[01])$");
    private static final int USEFUL_FRACTION_OF_SECOND_LENGTH = 3;
    private static final int[] FRACTION_OF_SECOND_MULTIPLIERS = new int[]{100, 10, 1};

    public static Long subtractTimeZoneOffset(long timestamp, TimeZone timeZone) {
        int offset = timeZone.getOffset(timestamp - (long)timeZone.getOffset(timestamp));
        return IgniteSqlFunctions.toTimestampLtzExact(timestamp - (long)offset);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static Long adjustTimestampMillis(@Nullable Long timestamp, int fractionOfSecond) {
        long unit;
        if (timestamp == null) {
            return null;
        }
        assert (fractionOfSecond >= 0);
        switch (fractionOfSecond) {
            case 0: {
                unit = 1000L;
                break;
            }
            case 1: {
                unit = 100L;
                break;
            }
            case 2: {
                unit = 10L;
                break;
            }
            default: {
                return timestamp;
            }
        }
        return timestamp - Math.floorMod((long)timestamp, unit);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static Integer adjustTimeMillis(@Nullable Integer time, int fractionOfSecond) {
        int unit;
        if (time == null) {
            return null;
        }
        assert (time >= 0) : time;
        assert (fractionOfSecond >= 0);
        switch (fractionOfSecond) {
            case 0: {
                unit = 1000;
                break;
            }
            case 1: {
                unit = 100;
                break;
            }
            case 2: {
                unit = 10;
                break;
            }
            default: {
                return time;
            }
        }
        return time - time % unit;
    }

    public static int currentDate(DataContext ctx) {
        long timestamp = (Long)DataContext.Variable.LOCAL_TIMESTAMP.get(ctx);
        int date = SqlFunctions.timestampToDate((long)timestamp);
        int time = SqlFunctions.timestampToTime((long)timestamp);
        if (time < 0) {
            --date;
        }
        return date;
    }

    public static String unixTimeToString(int time, int precision) {
        IgniteStringBuilder buf = new IgniteStringBuilder(8 + (precision > 0 ? 1 + precision : 0));
        IgniteSqlDateTimeUtils.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    private static void unixTimeToString(IgniteStringBuilder buf, int time, int precision) {
        int h = time / 3600000;
        int time2 = time % 3600000;
        int m = time2 / 60000;
        int time3 = time2 % 60000;
        int s = time3 / 1000;
        int ms = time3 % 1000;
        buf.app((char)(48 + h / 10 % 10)).app((char)(48 + h % 10)).app(':').app((char)(48 + m / 10 % 10)).app((char)(48 + m % 10)).app(':').app((char)(48 + s / 10 % 10)).app((char)(48 + s % 10));
        if (precision == 0 || ms == 0) {
            return;
        }
        buf.app('.');
        do {
            buf.app((char)(48 + ms / 100));
            ms %= 100;
        } while ((ms *= 10) > 0 && --precision > 0);
    }

    public static String unixTimestampToString(long timestamp, int precision) {
        IgniteStringBuilder buf = new IgniteStringBuilder(17);
        int date = (int)(timestamp / 86400000L);
        int time = (int)(timestamp % 86400000L);
        if (time < 0) {
            --date;
            time += 86400000;
        }
        buf.app(DateTimeUtils.unixDateToString((int)date)).app(' ');
        IgniteSqlDateTimeUtils.unixTimeToString(buf, time, precision);
        return buf.toString();
    }

    public static int timeStringToUnixDate(String value) {
        value = value.trim();
        IgniteSqlDateTimeUtils.validateTime(value, value);
        return IgniteSqlDateTimeUtils.timeStringToUnixDate(value, value);
    }

    private static int timeStringToUnixDate(String v, String full) {
        int second;
        int minute;
        int hour;
        int colon1 = v.indexOf(58);
        int milli = 0;
        try {
            if (colon1 < 0) {
                hour = Integer.parseInt(v.trim());
                minute = 0;
                second = 0;
            } else {
                hour = Integer.parseInt(v.substring(0, colon1).trim());
                int colon2 = v.indexOf(58, colon1 + 1);
                if (colon2 < 0) {
                    minute = Integer.parseInt(v.substring(colon1 + 1).trim());
                    second = 0;
                } else {
                    minute = Integer.parseInt(v.substring(colon1 + 1, colon2).trim());
                    int dot = v.indexOf(46, colon2);
                    if (dot < 0) {
                        second = Integer.parseInt(v.substring(colon2 + 1).trim());
                    } else {
                        second = Integer.parseInt(v.substring(colon2 + 1, dot).trim());
                        String fraction = v.substring(dot + 1).trim();
                        for (int i = 0; i < Math.min(fraction.length(), 3); ++i) {
                            int x = fraction.charAt(i) - 48;
                            assert (x >= 0 && x <= 9) : x;
                            milli += FRACTION_OF_SECOND_MULTIPLIERS[i] * x;
                        }
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw IgniteSqlDateTimeUtils.invalidType("TIME", full, e);
        }
        return hour * 3600000 + minute * 60000 + second * 1000 + milli;
    }

    public static long timestampStringToUnixDate(String s) {
        try {
            long t;
            long d;
            s = s.trim();
            int space = s.indexOf(32);
            if (space >= 0) {
                String datePart = s.substring(0, space);
                IgniteSqlDateTimeUtils.validateDate(datePart, s);
                d = DateTimeUtils.dateStringToUnixDate((String)datePart);
                String timePart = s.substring(space + 1);
                IgniteSqlDateTimeUtils.validateTime(timePart, s);
                t = IgniteSqlDateTimeUtils.timeStringToUnixDate(timePart, s);
            } else {
                IgniteSqlDateTimeUtils.validateDate(s, s);
                d = DateTimeUtils.dateStringToUnixDate((String)s);
                t = 0L;
            }
            return d * 86400000L + t;
        }
        catch (NumberFormatException e) {
            throw IgniteSqlDateTimeUtils.invalidType("TIMESTAMP", s, e);
        }
    }

    public static boolean isYearOutOfRange(String value) {
        int pos = value.indexOf(45);
        if (pos < 1) {
            return true;
        }
        try {
            String yearString = value.substring(0, pos);
            long year = Long.parseLong(yearString);
            return year > 9999L;
        }
        catch (NumberFormatException ignore) {
            return true;
        }
    }

    private static void validateTime(String time, String full) {
        Matcher matcher = TIME_PATTERN.matcher(time);
        if (!matcher.find()) {
            throw IgniteSqlDateTimeUtils.invalidType("TIME", full, null);
        }
        IgniteSqlDateTimeUtils.checkRange(matcher.group(1), 23, "HOUR", full);
        IgniteSqlDateTimeUtils.checkRange(matcher.group(2), 59, "MINUTE", full);
        IgniteSqlDateTimeUtils.checkRange(matcher.group(3), 59, "SECOND", full);
    }

    private static void checkRange(String intValue, int maxVal, String fieldName, String full) {
        try {
            int value = Integer.parseInt(intValue);
            if (value > maxVal) {
                throw IgniteSqlDateTimeUtils.fieldOutOfRange(fieldName, full, null);
            }
        }
        catch (NumberFormatException e) {
            throw IgniteSqlDateTimeUtils.fieldOutOfRange(fieldName, full, e);
        }
    }

    private static void validateDate(String s, String full) {
        Matcher matcher = DATE_PATTERN.matcher(s);
        if (!matcher.find()) {
            throw IgniteSqlDateTimeUtils.invalidType("DATE", full, null);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        IgniteSqlDateTimeUtils.checkLegalDate(year, month, day, full);
    }

    private static void checkLegalDate(int year, int month, int day, String full) {
        if (day > IgniteSqlDateTimeUtils.daysInMonth(year, month)) {
            throw IgniteSqlDateTimeUtils.fieldOutOfRange("DAY", full, null);
        }
        if (month < 1 || month > 12) {
            throw IgniteSqlDateTimeUtils.fieldOutOfRange("MONTH", full, null);
        }
        if (year <= 0) {
            throw IgniteSqlDateTimeUtils.fieldOutOfRange("YEAR", full, null);
        }
    }

    private static int daysInMonth(int year, int month) {
        switch (month) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return Year.isLeap(year) ? 29 : 28;
            }
        }
        return 31;
    }

    private static IllegalArgumentException fieldOutOfRange(String field, String full, @Nullable Exception cause) {
        return new IllegalArgumentException("Value of " + field + " field is out of range in '" + full + "'", cause);
    }

    private static IllegalArgumentException invalidType(String type, String full, @Nullable Exception cause) {
        return new IllegalArgumentException("Invalid " + type + " value, '" + full + "'", cause);
    }
}

