/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.ImmutableFilterSortTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterSortTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterSortTransposeRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Sort sort = (Sort)call.rel(1);
        RelBuilder builder = call.builder();
        RexNode condition = filter.getCondition();
        RelNode newSort = builder.push(sort.getInput()).filter(condition).sort(sort.getCollation()).build();
        call.transformTo(newSort);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterSortTransposeRule.Config.of().withOperandSupplier(f -> f.operand(Filter.class).oneInput(s -> s.operand(Sort.class).predicate(RelOptUtil::isPureOrder).anyInputs()));

        @Override
        default public FilterSortTransposeRule toRule() {
            return new FilterSortTransposeRule(this);
        }
    }
}

