/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import java.util.List;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;

public class ConvertToChecked
extends RelHomogeneousShuttle {
    final ConvertRexToChecked converter;

    public ConvertToChecked(RexBuilder builder) {
        this.converter = new ConvertRexToChecked(builder);
    }

    @Override
    public RelNode visit(RelNode other) {
        RelNode mNode = super.visitChildren(other);
        return mNode.accept(this.converter);
    }

    class ConvertRexToChecked
    extends RexShuttle {
        private final RexBuilder builder;

        ConvertRexToChecked(RexBuilder builder) {
            this.builder = builder;
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            RelNode result = subQuery.rel.accept(ConvertToChecked.this);
            if (result != subQuery.rel) {
                return subQuery.clone(result);
            }
            return subQuery;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            boolean[] update = new boolean[]{false};
            List<RexNode> clonedOperands = this.visitList((List<? extends RexNode>)call.operands, update);
            SqlKind kind = call.getKind();
            SqlOperator operator = call.getOperator();
            switch (kind) {
                case PLUS: {
                    operator = SqlStdOperatorTable.CHECKED_PLUS;
                    break;
                }
                case MINUS: {
                    operator = SqlStdOperatorTable.CHECKED_MINUS;
                    break;
                }
                case TIMES: {
                    operator = SqlStdOperatorTable.CHECKED_MULTIPLY;
                    break;
                }
                case MINUS_PREFIX: {
                    operator = SqlStdOperatorTable.CHECKED_UNARY_MINUS;
                    break;
                }
                case DIVIDE: {
                    operator = SqlStdOperatorTable.CHECKED_DIVIDE;
                    break;
                }
            }
            SqlTypeName resultType = call.getType().getSqlTypeName();
            if (resultType == SqlTypeName.DECIMAL) {
                RexCall result = operator == call.getOperator() ? call.clone(call.getType(), clonedOperands) : call;
                return this.builder.makeCast(call.getType(), result);
            }
            if (!SqlTypeName.EXACT_TYPES.contains((Object)resultType)) {
                operator = call.getOperator();
            }
            boolean bl = update[0] = update[0] || operator != call.getOperator();
            if (update[0]) {
                if (operator == call.getOperator()) {
                    return call.clone(call.getType(), clonedOperands);
                }
                return this.builder.makeCall(call.getParserPosition(), call.getType(), operator, clonedOperands);
            }
            return call;
        }
    }
}

