/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.fdetector;

import io.scalecube.cluster.Member;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringJoiner;

final class PingData
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Member from;
    private Member to;
    private Member originalIssuer;
    private AckType ackType;

    public PingData() {
    }

    private PingData(PingData other) {
        this.from = other.from;
        this.to = other.to;
        this.originalIssuer = other.originalIssuer;
        this.ackType = other.ackType;
    }

    public PingData(Member from, Member to) {
        this.from = from;
        this.to = to;
        this.originalIssuer = null;
        this.ackType = null;
    }

    public PingData(Member from, Member to, Member originalIssuer) {
        this.from = from;
        this.to = to;
        this.originalIssuer = originalIssuer;
        this.ackType = null;
    }

    public Member getFrom() {
        return this.from;
    }

    public Member getTo() {
        return this.to;
    }

    public Member getOriginalIssuer() {
        return this.originalIssuer;
    }

    public AckType getAckType() {
        return this.ackType;
    }

    public PingData withAckType(AckType ackType) {
        PingData p = new PingData(this);
        p.ackType = ackType;
        return p;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.from);
        out.writeObject(this.to);
        out.writeObject(this.originalIssuer);
        out.writeObject((Object)this.ackType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.from = (Member)in.readObject();
        this.to = (Member)in.readObject();
        this.originalIssuer = (Member)in.readObject();
        this.ackType = (AckType)((Object)in.readObject());
    }

    public String toString() {
        return new StringJoiner(", ", PingData.class.getSimpleName() + "[", "]").add("from=" + this.from).add("to=" + this.to).add("originalIssuer=" + this.originalIssuer).add("ackType=" + (Object)((Object)this.ackType)).toString();
    }

    static enum AckType {
        DEST_OK,
        DEST_GONE;

    }
}

