/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow.builder;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.flow.Flow;
import org.apache.ignite.internal.cli.core.flow.builder.Flows;
import org.apache.ignite.internal.cli.core.flow.question.QuestionAnswer;

public interface FlowBuilder<I, O> {
    public <OT> FlowBuilder<I, OT> then(Flow<O, OT> var1);

    default public <OT> FlowBuilder<I, OT> map(Function<O, OT> mapper) {
        return this.then(Flows.mono(mapper));
    }

    public <OT> FlowBuilder<I, OT> flatMap(Function<O, FlowBuilder<O, OT>> var1);

    public <OT> FlowBuilder<I, O> ifThen(Predicate<O> var1, Flow<O, OT> var2);

    public <QT> FlowBuilder<I, QT> question(String var1, List<QuestionAnswer<O, QT>> var2);

    public <QT> FlowBuilder<I, QT> question(Function<O, String> var1, List<QuestionAnswer<O, QT>> var2);

    public FlowBuilder<I, O> exceptionHandler(ExceptionHandler<?> var1);

    public FlowBuilder<I, O> onSuccess(Consumer<O> var1);

    default public FlowBuilder<I, O> onSuccess(Runnable handler) {
        return this.onSuccess((O result) -> handler.run());
    }

    public FlowBuilder<I, O> onFailure(Consumer<Throwable> var1);

    default public FlowBuilder<I, O> onFailure(Runnable handler) {
        return this.onFailure((Throwable throwable) -> handler.run());
    }

    public FlowBuilder<I, O> verbose(boolean[] var1);

    public FlowBuilder<I, O> print(Decorator<O, TerminalOutput> var1);

    public FlowBuilder<I, O> print();

    public Flow<I, O> build();

    public void start();
}

