/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.Arrays;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.services.Service;
import org.apache.ignite.services.ServiceCallInterceptor;
import org.apache.ignite.services.ServiceConfiguration;

public class LazyServiceConfiguration
extends ServiceConfiguration {
    private static final long serialVersionUID = 0L;
    @GridToStringExclude
    private transient Service srvc;
    @GridToStringExclude
    private transient IgnitePredicate<ClusterNode> nodeFilter;
    @GridToStringExclude
    private transient ServiceCallInterceptor[] interceptors;
    private String srvcClsName;
    private byte[] srvcBytes;
    private byte[] nodeFilterBytes;
    private byte[] interceptorsBytes;
    @GridToStringExclude
    private String[] platformMtdNames;

    public LazyServiceConfiguration() {
    }

    public LazyServiceConfiguration(ServiceConfiguration cfg, byte[] srvcBytes, byte[] nodeFilterBytes, byte[] interceptorsBytes) {
        assert (cfg.getService() != null) : cfg;
        assert (srvcBytes != null);
        this.name = cfg.getName();
        this.totalCnt = cfg.getTotalCount();
        this.maxPerNodeCnt = cfg.getMaxPerNodeCount();
        this.cacheName = cfg.getCacheName();
        this.affKey = cfg.getAffinityKey();
        this.nodeFilter = cfg.getNodeFilter();
        this.nodeFilterBytes = nodeFilterBytes;
        this.srvcBytes = srvcBytes;
        this.srvc = cfg.getService();
        this.srvcClsName = this.srvc.getClass().getName();
        this.isStatisticsEnabled = cfg.isStatisticsEnabled();
        this.interceptors = cfg.getInterceptors();
        this.interceptorsBytes = interceptorsBytes;
    }

    public byte[] nodeFilterBytes() {
        return this.nodeFilterBytes;
    }

    public byte[] serviceBytes() {
        return this.srvcBytes;
    }

    public String serviceClassName() {
        return this.srvcClsName;
    }

    @Override
    public Service getService() {
        assert (this.srvc != null) : this;
        return this.srvc;
    }

    @Override
    public ServiceConfiguration setNodeFilter(IgnitePredicate<ClusterNode> nodeFilter) {
        this.nodeFilter = nodeFilter;
        return this;
    }

    @Override
    public IgnitePredicate<ClusterNode> getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    public ServiceCallInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public byte[] interceptorBytes() {
        return this.interceptorsBytes;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LazyServiceConfiguration)) {
            return super.equals(o);
        }
        if (!this.equalsIgnoreNodeFilter(o)) {
            return false;
        }
        LazyServiceConfiguration that = (LazyServiceConfiguration)o;
        return Arrays.equals(this.nodeFilterBytes, that.nodeFilterBytes);
    }

    @Override
    public boolean equalsIgnoreNodeFilter(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyServiceConfiguration that = (LazyServiceConfiguration)o;
        if (this.maxPerNodeCnt != that.getMaxPerNodeCount()) {
            return false;
        }
        if (this.totalCnt != that.getTotalCount()) {
            return false;
        }
        if (this.affKey != null ? !this.affKey.equals(that.getAffinityKey()) : that.getAffinityKey() != null) {
            return false;
        }
        if (this.cacheName != null ? !this.cacheName.equals(that.getCacheName()) : that.getCacheName() != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (!Arrays.equals(this.srvcBytes, that.srvcBytes)) {
            return false;
        }
        return Arrays.equals(this.interceptorsBytes, that.interceptorsBytes);
    }

    LazyServiceConfiguration platformMtdNames(String[] platformMtdNames) {
        this.platformMtdNames = platformMtdNames;
        return this;
    }

    String[] platformMtdNames() {
        return this.platformMtdNames;
    }

    @Override
    public String toString() {
        String svcCls = this.srvc == null ? "" : this.srvc.getClass().getSimpleName();
        String nodeFilterCls = this.nodeFilter == null ? "" : this.nodeFilter.getClass().getSimpleName();
        return S.toString(LazyServiceConfiguration.class, this, "name", (Object)this.name, "svcCls", (Object)svcCls, "nodeFilterCls", (Object)nodeFilterCls);
    }
}

