/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft;

import java.io.IOException;
import java.util.Set;
import org.apache.ignite3.internal.partition.replicator.raft.PartitionSnapshotInfo;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.storage.lease.LeaseInfoSerializer;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.jetbrains.annotations.Nullable;

public class PartitionSnapshotInfoSerializer
extends VersionedSerializer<PartitionSnapshotInfo> {
    public static final PartitionSnapshotInfoSerializer INSTANCE = new PartitionSnapshotInfoSerializer();

    @Override
    protected void writeExternalData(PartitionSnapshotInfo snapshotInfo, IgniteDataOutput out) throws IOException {
        out.writeLong(snapshotInfo.lastAppliedIndex());
        out.writeLong(snapshotInfo.lastAppliedTerm());
        PartitionSnapshotInfoSerializer.writeNullableObject(snapshotInfo.leaseInfo(), LeaseInfoSerializer.INSTANCE, out);
        PartitionSnapshotInfoSerializer.writeByteArray(snapshotInfo.configurationBytes(), out);
        PartitionSnapshotInfoSerializer.writeVarIntSet(snapshotInfo.tableIds(), out);
    }

    @Override
    protected PartitionSnapshotInfo readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        long lastAppliedIndex = in.readLong();
        long lastAppliedTerm = in.readLong();
        LeaseInfo leaseInfo = PartitionSnapshotInfoSerializer.readNullableObject(LeaseInfoSerializer.INSTANCE, in);
        byte[] configuration = PartitionSnapshotInfoSerializer.readByteArray(in);
        Set<Integer> tableIds = PartitionSnapshotInfoSerializer.readVarIntSet(in);
        return new PartitionSnapshotInfo(lastAppliedIndex, lastAppliedTerm, leaseInfo, configuration, tableIds);
    }

    private static void writeByteArray(byte[] array, IgniteDataOutput out) throws IOException {
        out.writeVarInt(array.length);
        out.writeByteArray(array);
    }

    private static <T> void writeNullableObject(@Nullable T object, VersionedSerializer<T> serializer, IgniteDataOutput out) throws IOException {
        if (object == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            serializer.writeExternal(object, out);
        }
    }

    private static byte[] readByteArray(IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        return in.readByteArray(length);
    }

    @Nullable
    private static <T> T readNullableObject(VersionedSerializer<T> serializer, IgniteDataInput in) throws IOException {
        boolean isNotNull = in.readBoolean();
        return isNotNull ? (T)serializer.readExternal(in) : null;
    }
}

