/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.deployment;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipInputStream;
import org.apache.ignite3.internal.deployunit.CachedDeploymentUnit;
import org.apache.ignite3.internal.deployunit.DeploymentUnit;
import org.apache.ignite3.internal.deployunit.ZipDeploymentUnit;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitWriteException;
import org.apache.ignite3.internal.deployunit.exception.DeploymentUnitZipException;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.rest.deployment.InputStreamCollector;
import org.apache.ignite3.lang.IgniteException;

public class ZipInputStreamCollector
implements InputStreamCollector {
    private static final IgniteLogger LOG = Loggers.forClass(ZipInputStreamCollector.class);
    private static final byte[] ZIP_MAGIC_HEADER = new byte[]{80, 75, 3, 4};
    private final TempStorage tempStorage;
    private IgniteException igniteException;
    private CompletableFuture<Path> future;

    public ZipInputStreamCollector(TempStorage tempStorage) {
        this.tempStorage = tempStorage;
    }

    @Override
    public void addInputStream(String filename, InputStream is) {
        InputStream result;
        if (this.future != null || this.igniteException != null) {
            ZipInputStreamCollector.safeClose(is);
            if (this.igniteException == null) {
                this.igniteException = new DeploymentUnitZipException("Deployment unit with unzip supports only single zip file.");
            }
            return;
        }
        InputStream inputStream = result = is.markSupported() ? is : new BufferedInputStream(is);
        if (ZipInputStreamCollector.isZip(result)) {
            this.future = this.tempStorage.store(filename, result).whenComplete((path, throwable) -> {
                try {
                    result.close();
                }
                catch (IOException e) {
                    LOG.error("Error with closing zip input stream.", (Throwable)e);
                }
            });
        } else {
            ZipInputStreamCollector.safeClose(result);
            this.igniteException = new DeploymentUnitZipException("Only zip file is supported.");
        }
    }

    private static void safeClose(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close non-zip input stream.", (Throwable)e);
        }
    }

    private static boolean isZip(InputStream is) {
        try {
            boolean isZip = Objects.deepEquals(ZIP_MAGIC_HEADER, is.readNBytes(4));
            is.reset();
            return isZip;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void rollback() throws Exception {
        this.tempStorage.rollback();
    }

    @Override
    public DeploymentUnit toDeploymentUnit() {
        if (this.igniteException != null) {
            throw this.igniteException;
        }
        return new CachedDeploymentUnit((CompletableFuture<DeploymentUnit>)this.future.thenApply(zip -> {
            try {
                return new ZipDeploymentUnit(new ZipInputStream(Files.newInputStream(zip, new OpenOption[0])));
            }
            catch (IOException e) {
                LOG.error("Error when creating zip deployment unit", (Throwable)e);
                throw new DeploymentUnitWriteException("Failed to create zip deployment unit", e);
            }
        }));
    }
}

