/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.indexing;

import java.util.Collection;
import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.SkipDaemon;
import org.apache.ignite.internal.managers.GridManagerAdapter;
import org.apache.ignite.internal.util.GridEmptyCloseableIterator;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingSpi;

@SkipDaemon
public class GridIndexingManager
extends GridManagerAdapter<IndexingSpi> {
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();

    public GridIndexingManager(GridKernalContext ctx) {
        super(ctx, (IgniteSpi[])new IndexingSpi[]{ctx.config().getIndexingSpi()});
    }

    @Override
    public void start() throws IgniteCheckedException {
        this.startSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        this.busyLock.block();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        if (this.ctx.config().isDaemon()) {
            return;
        }
        this.stopSpi();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> void store(String cacheName, K key, V val, long expirationTime) throws IgniteCheckedException {
        assert (key != null);
        assert (val != null);
        assert (this.enabled());
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to write to index (grid is stopping).");
        }
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Storing key to cache query index [key=" + key + ", value=" + val + "]");
            }
            ((IndexingSpi)this.getSpi()).store(cacheName, key, val, expirationTime);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public void remove(String cacheName, Object key) throws IgniteCheckedException {
        assert (key != null);
        assert (this.enabled());
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to remove from index (grid is stopping).");
        }
        try {
            ((IndexingSpi)this.getSpi()).remove(cacheName, key);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IgniteSpiCloseableIterator<?> query(String cacheName, Collection<Object> params, IndexingQueryFilter filters) throws IgniteCheckedException {
        if (!this.enabled()) {
            throw new IgniteCheckedException("Indexing SPI is not configured.");
        }
        if (!this.busyLock.enterBusy()) {
            throw new IllegalStateException("Failed to execute query (grid is stopping).");
        }
        try {
            final Iterator<Cache.Entry<?, ?>> res = ((IndexingSpi)this.getSpi()).query(cacheName, params, filters);
            if (res == null) {
                GridEmptyCloseableIterator gridEmptyCloseableIterator = new GridEmptyCloseableIterator();
                return gridEmptyCloseableIterator;
            }
            IgniteSpiCloseableIterator<Object> igniteSpiCloseableIterator = new IgniteSpiCloseableIterator<Object>(){

                @Override
                public void close() throws IgniteCheckedException {
                    if (res instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)res)).close();
                        }
                        catch (Exception e) {
                            throw new IgniteCheckedException(e);
                        }
                    }
                }

                @Override
                public boolean hasNext() {
                    return res.hasNext();
                }

                @Override
                public Object next() {
                    return res.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            return igniteSpiCloseableIterator;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

