/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.util.index;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bifromq.util.index.ValueRef;
import org.apache.bifromq.util.index.ValueStrategy;

final class StrategySet<T>
extends AbstractSet<T> {
    private final ValueStrategy<T> strategy;
    private final HashSet<ValueRef<T>> refs = new HashSet();

    StrategySet(ValueStrategy<T> strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean add(T t) {
        return this.refs.add(ValueRef.of(t, this.strategy));
    }

    @Override
    public boolean contains(Object o) {
        Object t = o;
        return this.refs.contains(ValueRef.of(t, this.strategy));
    }

    @Override
    public boolean remove(Object o) {
        Object t = o;
        return this.refs.remove(ValueRef.of(t, this.strategy));
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<ValueRef<T>> it = this.refs.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                return ((ValueRef)it.next()).value;
            }
        };
    }

    @Override
    public int size() {
        return this.refs.size();
    }
}

