/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import com.google.protobuf.ByteString;
import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basekv.proto.StoreKey;

class CRDTUtil {
    private static final String PREFIX_BALANCER_STATE = "balancerState-";
    private static final String PREFIX_BALANCER_STATE_PROPOSAL = "balancerState-proposal-";
    private static final String PREFIX_LOAD_RULES = "loadRules-";
    private static final String PREFIX_LOAD_RULES_PROPOSAL = "loadRules-proposal-";
    private static final String PREFIX_LANDSCAPE = "landscape-";

    CRDTUtil() {
    }

    static StoreKey parseDescriptorKey(ByteString key) {
        return StoreKey.parseFrom(key);
    }

    static String toBalancerStateURI(String clusterId) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)(PREFIX_BALANCER_STATE + clusterId));
    }

    static String toBalancerStateProposalURI(String clusterId) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)(PREFIX_BALANCER_STATE_PROPOSAL + clusterId));
    }

    static String toLoadRulesURI(String clusterId) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)(PREFIX_LOAD_RULES + clusterId));
    }

    static String toLoadRulesProposalURI(String clusterId) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)(PREFIX_LOAD_RULES_PROPOSAL + clusterId));
    }

    static String toLandscapeURI(String clusterId) {
        return CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)(PREFIX_LANDSCAPE + clusterId));
    }

    static boolean isLandscapeURI(String crdtURI) {
        if (!CRDTURI.isValidURI((String)crdtURI)) {
            return false;
        }
        CausalCRDTType type = CRDTURI.parseType((String)crdtURI);
        String name = CRDTURI.parseName((String)crdtURI);
        return type == CausalCRDTType.ormap && name.startsWith(PREFIX_LANDSCAPE);
    }

    static String parseClusterId(String landscapeURI) {
        assert (CRDTUtil.isLandscapeURI(landscapeURI));
        return CRDTURI.parseName((String)landscapeURI).substring(PREFIX_LANDSCAPE.length());
    }
}

