/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.kie.kogito.quarkus.workflows;

import org.junit.jupiter.api.Test;

import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.restassured.http.ContentType;

import static io.restassured.RestAssured.given;
import static org.hamcrest.CoreMatchers.is;

@QuarkusIntegrationTest
class RetriggerIT {

    @Test
    void testRetrigger() {
        String id = given()
                .contentType(ContentType.JSON)
                .accept(ContentType.JSON)
                .body("{\"number1\":2,\"number2\":0}").when()
                .post("/division")
                .then()
                .statusCode(400)
                .extract().path("id");

        given()
                .contentType(ContentType.JSON)
                .accept(ContentType.JSON)
                .body("{\"number2\":1}").when()
                .patch("/division/{id}", id)
                .then()
                .statusCode(200);

        given()
                .contentType(ContentType.JSON)
                .accept(ContentType.JSON).when()
                .post("/management/processes/division/instances/{id}/retrigger", id)
                .then().statusCode(200).body("workflowdata.response", is(2));

        given()
                .contentType(ContentType.JSON)
                .accept(ContentType.JSON).when()
                .get("/division/{id}", id)
                .then().statusCode(404);
    }

}
