/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.rpc;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.livy.rsc.rpc.Rpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcDispatcher
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RpcDispatcher.class);
    private final Map<Channel, Rpc> channelRpc = new ConcurrentHashMap<Channel, Rpc>();

    protected String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void registerRpc(Channel channel, Rpc rpc) {
        this.channelRpc.put(channel, rpc);
    }

    public void unregisterRpc(Channel channel) {
        this.channelRpc.remove(channel);
    }

    private Rpc getRpc(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        if (!this.channelRpc.containsKey(channel)) {
            throw new IllegalArgumentException("not existed channel:" + channel);
        }
        return this.channelRpc.get(channel);
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.getRpc(ctx).handleMsg(ctx, msg, ((Object)((Object)this)).getClass(), (Object)this);
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.getRpc(ctx).handleChannelException(ctx, cause);
    }

    public final void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.getRpc(ctx).handleChannelInactive();
        super.channelInactive(ctx);
    }
}

