/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import com.google.common.io.Files;
import com.google.common.primitives.Longs;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.IOUtils;

@InterfaceAudience.Private
public class BestEffortLongFile
implements Closeable {
    private final File file;
    private final long defaultVal;
    private long value;
    private FileChannel ch = null;
    private final ByteBuffer buf = ByteBuffer.allocate(8);

    public BestEffortLongFile(File file, long defaultVal) {
        this.file = file;
        this.defaultVal = defaultVal;
    }

    public long get() throws IOException {
        this.lazyOpen();
        return this.value;
    }

    public void set(long newVal) throws IOException {
        this.lazyOpen();
        this.buf.clear();
        this.buf.putLong(newVal);
        this.buf.flip();
        IOUtils.writeFully((FileChannel)this.ch, (ByteBuffer)this.buf, (long)0L);
        this.value = newVal;
    }

    private void lazyOpen() throws IOException {
        if (this.ch != null) {
            return;
        }
        byte[] data = null;
        try {
            data = Files.toByteArray((File)this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (data != null && data.length != 0) {
            if (data.length != 8) {
                throw new IOException("File " + this.file + " had invalid length: " + data.length);
            }
            this.value = Longs.fromByteArray((byte[])data);
        } else {
            this.value = this.defaultVal;
        }
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        try {
            this.ch = raf.getChannel();
        }
        finally {
            if (this.ch == null) {
                IOUtils.closeStream((Closeable)raf);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.ch != null) {
            this.ch.close();
            this.ch = null;
        }
    }
}

