/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.EnumSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.server.recovery.StateStore;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001\u0002\b\u0010\u0001iA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tO\u0001\u0011\t\u0011)A\u0005Q!)a\u0007\u0001C\u0001o!)a\u0007\u0001C\u0001w!9Q\b\u0001b\u0001\n\u0013q\u0004BB$\u0001A\u0003%q\bC\u0004I\u0001\t\u0007I\u0011B%\t\r)\u0003\u0001\u0015!\u0003/\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\u0007\u0001\t\u0013\tiB\u0001\u000bGS2,7+_:uK6\u001cF/\u0019;f'R|'/\u001a\u0006\u0003!E\t\u0001B]3d_Z,'/\u001f\u0006\u0003%M\taa]3sm\u0016\u0014(B\u0001\u000b\u0016\u0003\u0011a\u0017N^=\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011d\b\t\u00039ui\u0011aD\u0005\u0003==\u0011!b\u0015;bi\u0016\u001cFo\u001c:f!\t\u0001\u0013%D\u0001\u0014\u0013\t\u00113CA\u0004M_\u001e<\u0017N\\4\u0002\u00111Lg/_\"p]\u001a\u0004\"\u0001I\u0013\n\u0005\u0019\u001a\"\u0001\u0003'jmf\u001cuN\u001c4\u0002\u001f5|7m\u001b$jY\u0016\u001cuN\u001c;fqR\u00042!\u000b\u0017/\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB(qi&|g\u000e\u0005\u00020i5\t\u0001G\u0003\u00022e\u0005\u0011am\u001d\u0006\u0003gU\ta\u0001[1e_>\u0004\u0018BA\u001b1\u0005-1\u0015\u000e\\3D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\rA\u0014H\u000f\t\u00039\u0001AQaI\u0002A\u0002\u0011BQaJ\u0002A\u0002!\"\"\u0001\u000f\u001f\t\u000b\r\"\u0001\u0019\u0001\u0013\u0002\u000b\u0019\u001cXK]5\u0016\u0003}\u0002\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u00079,GOC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019\u000b%aA+S\u0013\u00061am]+sS\u0002\n1BZ5mK\u000e{g\u000e^3yiV\ta&\u0001\u0007gS2,7i\u001c8uKb$\b%A\u0002tKR$2!\u0014)^!\tIc*\u0003\u0002PU\t!QK\\5u\u0011\u0015\t\u0016\u00021\u0001S\u0003\rYW-\u001f\t\u0003'js!\u0001\u0016-\u0011\u0005USS\"\u0001,\u000b\u0005]K\u0012A\u0002\u001fs_>$h(\u0003\u0002ZU\u00051\u0001K]3eK\u001aL!a\u0017/\u0003\rM#(/\u001b8h\u0015\tI&\u0006C\u0003_\u0013\u0001\u0007q,A\u0003wC2,X\r\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0007\u0006!A.\u00198h\u0013\t!\u0017M\u0001\u0004PE*,7\r^\u0001\u0004O\u0016$XCA4m)\tAW\u0010\u0006\u0002jkB\u0019\u0011\u0006\f6\u0011\u0005-dG\u0002\u0001\u0003\u0006[*\u0011\rA\u001c\u0002\u0002)F\u0011qN\u001d\t\u0003SAL!!\u001d\u0016\u0003\u000f9{G\u000f[5oOB\u0011\u0011f]\u0005\u0003i*\u00121!\u00118z\u0011\u001d1(\"!AA\u0004]\f!\"\u001a<jI\u0016t7-\u001a\u00132!\rA8P[\u0007\u0002s*\u0011!PK\u0001\be\u00164G.Z2u\u0013\ta\u0018P\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011\u0015\t&\u00021\u0001S\u0003-9W\r^\"iS2$'/\u001a8\u0015\t\u0005\u0005\u00111\u0003\t\u0006\u0003\u0007\tiA\u0015\b\u0005\u0003\u000b\tIAD\u0002V\u0003\u000fI\u0011aK\u0005\u0004\u0003\u0017Q\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\t\tBA\u0002TKFT1!a\u0003+\u0011\u0015\t6\u00021\u0001S\u0003\u0019\u0011X-\\8wKR\u0019Q*!\u0007\t\u000bEc\u0001\u0019\u0001*\u0002\u000f\u0005\u00147\u000fU1uQR!\u0011qDA\u0013!\ry\u0013\u0011E\u0005\u0004\u0003G\u0001$\u0001\u0002)bi\"DQ!U\u0007A\u0002I\u0003")
public class FileSystemStateStore
extends StateStore
implements Logging {
    private final URI fsUri;
    private final FileContext fileContext;
    private Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FileSystemStateStore fileSystemStateStore = this;
        synchronized (fileSystemStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private URI fsUri() {
        return this.fsUri;
    }

    private FileContext fileContext() {
        return this.fileContext;
    }

    @Override
    public void set(String key, Object value) {
        Path tmpPath = this.absPath(new StringBuilder(4).append(key).append(".tmp").toString());
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        Utils$.MODULE$.usingResource((Closeable)this.fileContext().create(tmpPath, createFlag, new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1 & Serializable & scala.Serializable)tmpFile -> {
            FileSystemStateStore.$anonfun$set$1(this, value, tmpPath, key, tmpFile);
            return BoxedUnit.UNIT;
        });
        try {
            Path crcPath = new Path(tmpPath.getParent(), new StringBuilder(5).append(".").append(tmpPath.getName()).append(".crc").toString());
            this.fileContext().delete(crcPath, false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    @Override
    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        None$ none$;
        try {
            none$ = (Option)Utils$.MODULE$.usingResource((Closeable)this.fileContext().open(this.absPath(key)), (Function1 & Serializable & scala.Serializable)is -> Option$.MODULE$.apply(this.deserialize(IOUtils.toByteArray((InputStream)is), evidence$1)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            none$ = None$.MODULE$;
        }
        catch (IOException e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to read ").append(key).append(" from state store.").toString(), e);
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Seq<String> getChildren(String key) {
        Seq seq;
        try {
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileContext().util().listStatus(this.absPath(key)))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().getName(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            seq = (Seq)Nil$.MODULE$;
        }
        catch (IOException e) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Failed to list ").append(key).append(" from state store.").toString(), e);
            seq = (Seq)Nil$.MODULE$;
        }
        return seq;
    }

    @Override
    public void remove(String key) {
        try {
            this.fileContext().delete(this.absPath(key), false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Failed to remove non-existed file: ").append(key).toString());
        }
    }

    private Path absPath(String key) {
        return new Path(this.fsUri().getPath(), key);
    }

    public static final /* synthetic */ void $anonfun$set$1(FileSystemStateStore $this, Object value$1, Path tmpPath$1, String key$1, FSDataOutputStream tmpFile) {
        tmpFile.write($this.serializeToBytes(value$1));
        tmpFile.close();
        $this.fileContext().rename(tmpPath$1, $this.absPath(key$1), new Options.Rename[]{Options.Rename.OVERWRITE});
    }

    public FileSystemStateStore(LivyConf livyConf, Option<FileContext> mockFileContext) {
        block4: {
            block3: {
                super(livyConf);
                Logging.$init$((Logging)this);
                String fsPath = livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL());
                Predef$.MODULE$.require(fsPath != null && !fsPath.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Please config ").append(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL().key()).append(".").toString());
                this.fsUri = new URI(fsPath);
                this.fileContext = (FileContext)mockFileContext.getOrElse((Function0 & Serializable & scala.Serializable)() -> FileContext.getFileContext((URI)this.fsUri()));
                this.fileContext().setUMask(new FsPermission("077"));
                Path stateStorePath = this.absPath(".");
                try {
                    this.fileContext().mkdir(stateStorePath, FsPermission.getDirDefault(), true);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    if (this.fileContext().getFileStatus(stateStorePath).isDirectory()) break block3;
                    throw new IOException(new StringBuilder(20).append(stateStorePath).append(" is not a directory.").toString());
                }
            }
            FileStatus fileStatus = this.fileContext().getFileStatus(this.absPath("."));
            FsAction fsAction = fileStatus.getPermission().getUserAction();
            FsAction fsAction2 = FsAction.ALL;
            Predef$.MODULE$.require(!(fsAction != null ? !fsAction.equals(fsAction2) : fsAction2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Livy doesn't have permission to access state store: ").append(this.fsUri()).append(".").toString());
            FsAction fsAction3 = fileStatus.getPermission().getGroupAction();
            FsAction fsAction4 = FsAction.NONE;
            if (fsAction3 == null ? fsAction4 != null : !fsAction3.equals(fsAction4)) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Group users have permission to access state store: ").append(this.fsUri()).append(". This is insecure.").toString());
            }
            FsAction fsAction5 = fileStatus.getPermission().getOtherAction();
            FsAction fsAction6 = FsAction.NONE;
            if (!(fsAction5 == null ? fsAction6 != null : !fsAction5.equals(fsAction6))) break block4;
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Other users have permission to access state store: ").append(this.fsUri()).append(". This is in secure.").toString());
        }
    }

    public FileSystemStateStore(LivyConf livyConf) {
        this(livyConf, (Option<FileContext>)None$.MODULE$);
    }
}

