/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.config;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.polaris.core.config.ProductionReadinessCheck;
import org.immutables.value.Generated;

@Generated(from="ProductionReadinessCheck.Error", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableError
implements ProductionReadinessCheck.Error {
    private final String message;
    private final String offendingProperty;
    private final boolean severe;
    private transient int hashCode;

    private ImmutableError(String message, String offendingProperty, boolean severe) {
        this.message = Objects.requireNonNull(message, "message");
        this.offendingProperty = Objects.requireNonNull(offendingProperty, "offendingProperty");
        this.severe = severe;
    }

    private ImmutableError(ImmutableError original, String message, String offendingProperty, boolean severe) {
        this.message = message;
        this.offendingProperty = offendingProperty;
        this.severe = severe;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String offendingProperty() {
        return this.offendingProperty;
    }

    @Override
    public boolean severe() {
        return this.severe;
    }

    public final ImmutableError withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableError(this, newValue, this.offendingProperty, this.severe);
    }

    public final ImmutableError withOffendingProperty(String value) {
        String newValue = Objects.requireNonNull(value, "offendingProperty");
        if (this.offendingProperty.equals(newValue)) {
            return this;
        }
        return new ImmutableError(this, this.message, newValue, this.severe);
    }

    public final ImmutableError withSevere(boolean value) {
        if (this.severe == value) {
            return this;
        }
        return new ImmutableError(this, this.message, this.offendingProperty, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableError && this.equalTo(0, (ImmutableError)another);
    }

    private boolean equalTo(int synthetic, ImmutableError another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.message.equals(another.message) && this.offendingProperty.equals(another.offendingProperty) && this.severe == another.severe;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.offendingProperty.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.severe);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Error").omitNullValues().add("message", (Object)this.message).add("offendingProperty", (Object)this.offendingProperty).add("severe", this.severe).toString();
    }

    public static ImmutableError of(String message, String offendingProperty, boolean severe) {
        return new ImmutableError(message, offendingProperty, severe);
    }

    public static ImmutableError copyOf(ProductionReadinessCheck.Error instance) {
        if (instance instanceof ImmutableError) {
            return (ImmutableError)instance;
        }
        return ImmutableError.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutableError.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProductionReadinessCheck.Error", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private static final long INIT_BIT_OFFENDING_PROPERTY = 2L;
        private static final long INIT_BIT_SEVERE = 4L;
        private long initBits = 7L;
        private String message;
        private String offendingProperty;
        private boolean severe;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ProductionReadinessCheck.Error instance) {
            Objects.requireNonNull(instance, "instance");
            this.message(instance.message());
            this.offendingProperty(instance.offendingProperty());
            this.severe(instance.severe());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder offendingProperty(String offendingProperty) {
            this.offendingProperty = Objects.requireNonNull(offendingProperty, "offendingProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder severe(boolean severe) {
            this.severe = severe;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 7L;
            this.message = null;
            this.offendingProperty = null;
            this.severe = false;
            return this;
        }

        public ImmutableError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableError(null, this.message, this.offendingProperty, this.severe);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("offendingProperty");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("severe");
            }
            return "Cannot build Error, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

