/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.config;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.context.SmallRyeManagedExecutor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Startup;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Singleton;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDefaultDiagServiceImpl;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.AuthenticatedPolarisPrincipal;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisAuthorizerImpl;
import org.apache.polaris.core.config.PolarisConfigurationStore;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.MetaStoreManagerFactory;
import org.apache.polaris.core.persistence.PolarisEntityManager;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.bootstrap.RootCredentialsSet;
import org.apache.polaris.core.secrets.UserSecretsManager;
import org.apache.polaris.core.secrets.UserSecretsManagerFactory;
import org.apache.polaris.core.storage.cache.StorageCredentialCache;
import org.apache.polaris.service.auth.ActiveRolesProvider;
import org.apache.polaris.service.auth.AuthenticationType;
import org.apache.polaris.service.auth.Authenticator;
import org.apache.polaris.service.auth.PrincipalAuthInfo;
import org.apache.polaris.service.auth.TokenBroker;
import org.apache.polaris.service.auth.TokenBrokerFactory;
import org.apache.polaris.service.catalog.api.IcebergRestOAuth2ApiService;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.config.RealmEntityManagerFactory;
import org.apache.polaris.service.context.RealmContextConfiguration;
import org.apache.polaris.service.context.RealmContextResolver;
import org.apache.polaris.service.events.PolarisEventListener;
import org.apache.polaris.service.quarkus.auth.QuarkusAuthenticationConfiguration;
import org.apache.polaris.service.quarkus.auth.QuarkusAuthenticationRealmConfiguration;
import org.apache.polaris.service.quarkus.auth.external.OidcConfiguration;
import org.apache.polaris.service.quarkus.auth.external.tenant.OidcTenantResolver;
import org.apache.polaris.service.quarkus.catalog.io.QuarkusFileIOConfiguration;
import org.apache.polaris.service.quarkus.context.QuarkusRealmContextConfiguration;
import org.apache.polaris.service.quarkus.events.QuarkusPolarisEventListenerConfiguration;
import org.apache.polaris.service.quarkus.persistence.QuarkusPersistenceConfiguration;
import org.apache.polaris.service.quarkus.ratelimiter.QuarkusRateLimiterFilterConfiguration;
import org.apache.polaris.service.quarkus.ratelimiter.QuarkusTokenBucketConfiguration;
import org.apache.polaris.service.quarkus.secrets.QuarkusSecretsManagerConfiguration;
import org.apache.polaris.service.ratelimiter.RateLimiter;
import org.apache.polaris.service.ratelimiter.TokenBucketFactory;
import org.apache.polaris.service.task.TaskHandlerConfiguration;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.context.ManagedExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LoggingEventBuilder;

public class QuarkusProducers {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuarkusProducers.class);

    @Produces
    @ApplicationScoped
    public Clock clock() {
        return Clock.systemUTC();
    }

    @Produces
    @ApplicationScoped
    public StorageCredentialCache storageCredentialCache() {
        return new StorageCredentialCache();
    }

    @Produces
    @ApplicationScoped
    public PolarisAuthorizer polarisAuthorizer(PolarisConfigurationStore configurationStore) {
        return new PolarisAuthorizerImpl(configurationStore);
    }

    @Produces
    @Singleton
    public PolarisDiagnostics polarisDiagnostics() {
        return new PolarisDefaultDiagServiceImpl();
    }

    @Produces
    @RequestScoped
    public RealmContext realmContext(@Context ContainerRequestContext request) {
        return (RealmContext)request.getProperty("realmContext");
    }

    @Produces
    @RequestScoped
    public CallContext polarisCallContext(RealmContext realmContext, PolarisDiagnostics diagServices, PolarisConfigurationStore configurationStore, MetaStoreManagerFactory metaStoreManagerFactory, Clock clock) {
        BasePersistence metaStoreSession = (BasePersistence)metaStoreManagerFactory.getOrCreateSessionSupplier(realmContext).get();
        return new PolarisCallContext(realmContext, metaStoreSession, diagServices, configurationStore, clock);
    }

    @Produces
    public RealmContextResolver realmContextResolver(QuarkusRealmContextConfiguration config, @Any Instance<RealmContextResolver> realmContextResolvers) {
        return (RealmContextResolver)realmContextResolvers.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public FileIOFactory fileIOFactory(QuarkusFileIOConfiguration config, @Any Instance<FileIOFactory> fileIOFactories) {
        return (FileIOFactory)fileIOFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public PolarisEventListener polarisEventListener(QuarkusPolarisEventListenerConfiguration config, @Any Instance<PolarisEventListener> polarisEventListeners) {
        return (PolarisEventListener)polarisEventListeners.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public MetaStoreManagerFactory metaStoreManagerFactory(QuarkusPersistenceConfiguration config, @Any Instance<MetaStoreManagerFactory> metaStoreManagerFactories) {
        return (MetaStoreManagerFactory)metaStoreManagerFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public UserSecretsManagerFactory userSecretsManagerFactory(QuarkusSecretsManagerConfiguration config, @Any Instance<UserSecretsManagerFactory> userSecretsManagerFactories) {
        return (UserSecretsManagerFactory)userSecretsManagerFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    public void maybeBootstrap(@Observes Startup event, MetaStoreManagerFactory factory, QuarkusPersistenceConfiguration config, RealmContextConfiguration realmContextConfiguration) {
        RootCredentialsSet rootCredentialsSet = RootCredentialsSet.fromEnvironment();
        Map rootCredentials = rootCredentialsSet.credentials();
        if (config.isAutoBootstrap()) {
            List realmIds = realmContextConfiguration.realms();
            LOGGER.info("Bootstrapping realm(s) {}, if necessary, from root credentials set provided via the environment variable {} or Java system property {} ...", new Object[]{realmIds.stream().map(r -> "'" + r + "'").collect(Collectors.joining(", ")), "POLARIS_BOOTSTRAP_CREDENTIALS", "polaris.bootstrap.credentials"});
            Map result = factory.bootstrapRealms((Iterable)realmIds, rootCredentialsSet);
            result.forEach((realm, secrets) -> {
                PolarisPrincipalSecrets principalSecrets = secrets.getPrincipalSecrets();
                LoggingEventBuilder log = LOGGER.atInfo().addArgument(realm).addArgument((Object)"POLARIS_BOOTSTRAP_CREDENTIALS").addArgument((Object)"polaris.bootstrap.credentials");
                if (rootCredentials.containsKey(realm)) {
                    log.log("Realm '{}' automatically bootstrapped, credentials taken from root credentials set provided via the environment variable {} or Java system property {}, not printed to stdout.");
                } else {
                    log.log("Realm '{}' automatically bootstrapped, credentials were not present in root credentials set provided via the environment variable {} or Java system property {}, see separate message printed to stdout.");
                    String msg = String.format("realm: %1s root principal credentials: %2s:%3s", realm, principalSecrets.getPrincipalClientId(), principalSecrets.getMainSecret());
                    System.out.println(msg);
                }
            });
            String unusedRealmSecrets = realmIds.stream().filter(rootCredentials::containsKey).filter(r -> !result.containsKey(r)).map(r -> "'" + r + "'").collect(Collectors.joining(", "));
            if (!unusedRealmSecrets.isEmpty()) {
                LOGGER.error("The realms {} are already fully bootstrapped but the secrets are still available via the environment variable {} or Java system property {}. Remove this security sensitive information from the environment / Java system properties!", new Object[]{unusedRealmSecrets, "POLARIS_BOOTSTRAP_CREDENTIALS", "polaris.bootstrap.credentials"});
            }
        } else if (!rootCredentials.isEmpty()) {
            LOGGER.error("Secrets for the realms {} are available via the environment variable {} or Java system property {}. Remove this security sensitive information from the environment / Java system properties!", new Object[]{rootCredentials.keySet(), "POLARIS_BOOTSTRAP_CREDENTIALS", "polaris.bootstrap.credentials"});
        }
    }

    @Produces
    public RateLimiter rateLimiter(QuarkusRateLimiterFilterConfiguration config, @Any Instance<RateLimiter> rateLimiters) {
        return (RateLimiter)rateLimiters.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    public TokenBucketFactory tokenBucketFactory(QuarkusTokenBucketConfiguration config, @Any Instance<TokenBucketFactory> tokenBucketFactories) {
        return (TokenBucketFactory)tokenBucketFactories.select(new Annotation[]{Identifier.Literal.of((String)config.type())}).get();
    }

    @Produces
    @RequestScoped
    public Authenticator<PrincipalAuthInfo, AuthenticatedPolarisPrincipal> authenticator(QuarkusAuthenticationRealmConfiguration config, @Any Instance<Authenticator<PrincipalAuthInfo, AuthenticatedPolarisPrincipal>> authenticators) {
        return (Authenticator)authenticators.select(new Annotation[]{Identifier.Literal.of((String)config.authenticator().type())}).get();
    }

    @Produces
    @RequestScoped
    public IcebergRestOAuth2ApiService icebergRestOAuth2ApiService(QuarkusAuthenticationRealmConfiguration config, @Any Instance<IcebergRestOAuth2ApiService> services) {
        String type = config.type() == AuthenticationType.EXTERNAL ? "disabled" : config.tokenService().type();
        return (IcebergRestOAuth2ApiService)services.select(new Annotation[]{Identifier.Literal.of((String)type)}).get();
    }

    @Produces
    @RequestScoped
    public TokenBroker tokenBroker(QuarkusAuthenticationRealmConfiguration config, RealmContext realmContext, @Any Instance<TokenBrokerFactory> tokenBrokerFactories) {
        String type = config.type() == AuthenticationType.EXTERNAL ? "none" : config.tokenBroker().type();
        TokenBrokerFactory tokenBrokerFactory = (TokenBrokerFactory)tokenBrokerFactories.select(new Annotation[]{Identifier.Literal.of((String)type)}).get();
        return (TokenBroker)tokenBrokerFactory.apply((Object)realmContext);
    }

    @Produces
    @Singleton
    @Identifier(value="task-executor")
    public ManagedExecutor taskExecutor(TaskHandlerConfiguration config) {
        return SmallRyeManagedExecutor.builder().injectionPointName("task-executor").propagated(new String[]{"Remaining"}).maxAsync(config.maxConcurrentTasks()).maxQueued(config.maxQueuedTasks()).build();
    }

    @Produces
    @RequestScoped
    public PolarisMetaStoreManager polarisMetaStoreManager(RealmContext realmContext, MetaStoreManagerFactory metaStoreManagerFactory) {
        return metaStoreManagerFactory.getOrCreateMetaStoreManager(realmContext);
    }

    @Produces
    @RequestScoped
    public UserSecretsManager userSecretsManager(RealmContext realmContext, UserSecretsManagerFactory userSecretsManagerFactory) {
        return userSecretsManagerFactory.getOrCreateUserSecretsManager(realmContext);
    }

    @Produces
    @RequestScoped
    public BasePersistence polarisMetaStoreSession(RealmContext realmContext, MetaStoreManagerFactory metaStoreManagerFactory) {
        return (BasePersistence)metaStoreManagerFactory.getOrCreateSessionSupplier(realmContext).get();
    }

    @Produces
    @RequestScoped
    public PolarisEntityManager polarisEntityManager(RealmContext realmContext, RealmEntityManagerFactory factory) {
        return factory.getOrCreateEntityManager(realmContext);
    }

    @Produces
    @RequestScoped
    public QuarkusAuthenticationRealmConfiguration realmAuthConfig(QuarkusAuthenticationConfiguration config, RealmContext realmContext) {
        return (QuarkusAuthenticationRealmConfiguration)config.forRealm(realmContext);
    }

    @Produces
    public ActiveRolesProvider activeRolesProvider(@ConfigProperty(name="polaris.active-roles-provider.type") String activeRolesProviderType, @Any Instance<ActiveRolesProvider> activeRolesProviders) {
        return (ActiveRolesProvider)activeRolesProviders.select(new Annotation[]{Identifier.Literal.of((String)activeRolesProviderType)}).get();
    }

    @Produces
    public OidcTenantResolver oidcTenantResolver(OidcConfiguration config, @Any Instance<OidcTenantResolver> resolvers) {
        return (OidcTenantResolver)resolvers.select(new Annotation[]{Identifier.Literal.of((String)config.tenantResolver())}).get();
    }

    public void closeTaskExecutor(@Disposes @Identifier(value="task-executor") ManagedExecutor executor) {
        executor.close();
    }
}

