/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.IdTokenCredential;
import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcProviderClient;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenIntrospection;
import io.quarkus.oidc.TokenIntrospectionCache;
import io.quarkus.oidc.UserInfo;
import io.quarkus.oidc.UserInfoCache;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.oidc.runtime.TokenAutoRefreshException;
import io.quarkus.oidc.runtime.TokenVerificationResult;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Key;
import java.security.Principal;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.lang.UnresolvableKeyException;

@ApplicationScoped
public class OidcIdentityProvider
implements IdentityProvider<TokenAuthenticationRequest> {
    private static final Logger LOG = Logger.getLogger(OidcIdentityProvider.class);
    static final String REFRESH_TOKEN_GRANT_RESPONSE = "refresh_token_grant_response";
    static final String NEW_AUTHENTICATION = "new_authentication";
    private static final Uni<TokenVerificationResult> NULL_CODE_ACCESS_TOKEN_UNI = Uni.createFrom().nullItem();
    protected final DefaultTenantConfigResolver tenantResolver;
    private final BlockingTaskRunner<Void> uniVoidOidcContext;
    private final BlockingTaskRunner<TokenIntrospection> getIntrospectionRequestContext;
    private final BlockingTaskRunner<UserInfo> getUserInfoRequestContext;

    OidcIdentityProvider(DefaultTenantConfigResolver tenantResolver, BlockingSecurityExecutor blockingExecutor) {
        this.tenantResolver = tenantResolver;
        this.uniVoidOidcContext = new BlockingTaskRunner(blockingExecutor);
        this.getIntrospectionRequestContext = new BlockingTaskRunner(blockingExecutor);
        this.getUserInfoRequestContext = new BlockingTaskRunner(blockingExecutor);
    }

    public Class<TokenAuthenticationRequest> getRequestType() {
        return TokenAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        if (!(request.getToken() instanceof AccessTokenCredential) && !(request.getToken() instanceof IdTokenCredential)) {
            return Uni.createFrom().nullItem();
        }
        LOG.debug((Object)"Starting creating SecurityIdentity");
        return this.resolveTenantConfigContext(request, context).onItem().transformToUni((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Uni<TenantConfigContext> resolveTenantConfigContext(TokenAuthenticationRequest request, AuthenticationRequestContext context) {
        return this.tenantResolver.resolveContext(HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request).put(AuthenticationRequestContext.class.getName(), (Object)context));
    }

    protected Map<String, Object> getRequestData(TokenAuthenticationRequest request) {
        return HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request).data();
    }

    private Uni<SecurityIdentity> authenticate(TokenAuthenticationRequest request, Map<String, Object> requestData, TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig().authServerUrl().isPresent()) {
            return this.validateAllTokensWithOidcServer(requestData, request, resolvedContext);
        }
        if (resolvedContext.oidcConfig().certificateChain().trustStoreFile().isPresent()) {
            LOG.debug((Object)"Performing token verification with a public key inlined in the certificate chain");
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        if (resolvedContext.oidcConfig().publicKey().isPresent()) {
            LOG.debug((Object)"Performing token verification with a configured public key");
            return OidcIdentityProvider.validateTokenWithoutOidcServer(request, resolvedContext);
        }
        return Uni.createFrom().failure((Throwable)new OIDCException("Unexpected authentication request"));
    }

    private Uni<SecurityIdentity> validateAllTokensWithOidcServer(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        if (resolvedContext.oidcConfig().token().verifyAccessTokenWithUserInfo().orElse(false).booleanValue() && this.isOpaqueAccessToken(requestData, request, resolvedContext)) {
            if (resolvedContext.oidcConfig().authentication().userInfoRequired().orElse(false).booleanValue()) {
                return this.getUserInfoUni(requestData, request, resolvedContext).onItemOrFailure().transformToUni((BiFunction)new /* Unavailable Anonymous Inner Class!! */);
            }
            return this.validateTokenWithUserInfoAndCreateIdentity(requestData, request, resolvedContext, null);
        }
        Uni<TokenVerificationResult> primaryTokenUni = this.verifyPrimaryTokenUni(requestData, request, resolvedContext, null);
        return this.getUserInfoAndCreateIdentity(primaryTokenUni, requestData, request, resolvedContext);
    }

    private Uni<SecurityIdentity> validateTokenWithUserInfoAndCreateIdentity(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        Uni<TokenVerificationResult> codeAccessTokenUni = this.verifyCodeFlowAccessTokenUni(requestData, request, resolvedContext, userInfo);
        return codeAccessTokenUni.onItemOrFailure().transformToUni((BiFunction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Uni<TokenVerificationResult> verifyPrimaryTokenUni(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        if (OidcIdentityProvider.isInternalIdToken(request)) {
            if (requestData.get(NEW_AUTHENTICATION) == Boolean.TRUE) {
                return Uni.createFrom().item((Object)new TokenVerificationResult(OidcCommonUtils.decodeJwtContent((String)request.getToken().getToken()), null));
            }
            return this.verifySelfSignedTokenUni(resolvedContext, request.getToken().getToken());
        }
        boolean idToken = OidcIdentityProvider.isIdToken(request);
        Uni result = this.verifyTokenUni(requestData, resolvedContext, request.getToken(), idToken, false, userInfo);
        if (!idToken) {
            if (resolvedContext.oidcConfig().token().binding().certificate()) {
                result = result.onItem().transform((Function)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (requestData.containsKey("dpop_proof_jwt_headers")) {
                result = result.onItem().transform((Function)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        return result;
    }

    private static String getTokenCertThumbprint(Map<String, Object> requestData, TokenVerificationResult t) {
        String thumbprint;
        JsonObject json = t.localVerificationResult != null ? t.localVerificationResult : new JsonObject(t.introspectionResult.getIntrospectionString());
        JsonObject cnf = json.getJsonObject("cnf");
        String string = thumbprint = cnf == null ? null : cnf.getString("x5t#S256");
        if (thumbprint != null) {
            requestData.put(t.introspectionResult == null ? "jwt_thumbprint" : "introspection_thumbprint", true);
        }
        return thumbprint;
    }

    private static String getDpopJwkThumbprint(Map<String, Object> requestData, TokenVerificationResult t) {
        String thumbprint;
        JsonObject json = t.localVerificationResult != null ? t.localVerificationResult : new JsonObject(t.introspectionResult.getIntrospectionString());
        JsonObject cnf = json.getJsonObject("cnf");
        String string = thumbprint = cnf == null ? null : cnf.getString("jkt");
        if (thumbprint != null) {
            requestData.put(t.introspectionResult == null ? "dpop_jwt_thumbprint" : "dpop_introspection_thumbprint", true);
        }
        return thumbprint;
    }

    private Uni<SecurityIdentity> getUserInfoAndCreateIdentity(Uni<TokenVerificationResult> tokenUni, Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        return tokenUni.onItemOrFailure().transformToUni((BiFunction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean isOpaqueAccessToken(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        if (request.getToken() instanceof AccessTokenCredential) {
            return ((AccessTokenCredential)request.getToken()).isOpaque();
        }
        if (request.getToken() instanceof IdTokenCredential && (resolvedContext.oidcConfig().authentication().verifyAccessToken() || resolvedContext.oidcConfig().roles().source().orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)requestData.get("access_token");
            return OidcUtils.isOpaqueToken((String)codeAccessToken);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Uni<SecurityIdentity> createSecurityIdentityWithOidcServer(TokenVerificationResult result, Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        String userName;
        QuarkusSecurityIdentity.Builder builder;
        block14: {
            TokenCredential tokenCred = request.getToken();
            JsonObject tokenJson = result.localVerificationResult;
            if (tokenJson == null) {
                tokenJson = OidcCommonUtils.decodeJwtContent((String)tokenCred.getToken());
            }
            if (tokenJson != null) {
                try {
                    OidcUtils.validatePrimaryJwtTokenType((OidcTenantConfig.Token)resolvedContext.oidcConfig().token(), (JsonObject)tokenJson);
                    if (userInfo != null && resolvedContext.oidcConfig().token().subjectRequired() && !tokenJson.getString(Claims.sub.name()).equals(userInfo.getString(Claims.sub.name()))) {
                        String errorMessage = "Token and UserInfo do not have matching `sub` claims";
                        return Uni.createFrom().failure((Throwable)new AuthenticationCompletionException(errorMessage));
                    }
                    JsonObject rolesJson = OidcIdentityProvider.getRolesJson(requestData, resolvedContext, tokenCred, tokenJson, userInfo);
                    QuarkusSecurityIdentity securityIdentity = OidcUtils.validateAndCreateIdentity(requestData, (TokenCredential)tokenCred, (TenantConfigContext)resolvedContext, (JsonObject)tokenJson, (JsonObject)rolesJson, (UserInfo)userInfo, (TokenIntrospection)result.introspectionResult, (TokenAuthenticationRequest)request);
                    if (OidcIdentityProvider.isIdToken(request) && OidcIdentityProvider.tokenAutoRefreshPrepared(result, requestData, resolvedContext.oidcConfig(), false)) {
                        return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)securityIdentity));
                    }
                    return Uni.createFrom().item((Object)securityIdentity);
                }
                catch (Throwable ex) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(ex));
                }
            }
            if (OidcIdentityProvider.isIdToken(request) || tokenCred instanceof AccessTokenCredential && !((AccessTokenCredential)tokenCred).isOpaque()) {
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("JWT token can not be converted to JSON"));
            }
            builder = QuarkusSecurityIdentity.builder();
            builder.addCredential((Credential)tokenCred);
            OidcUtils.setSecurityIdentityUserInfo((QuarkusSecurityIdentity.Builder)builder, (UserInfo)userInfo);
            OidcUtils.setSecurityIdentityConfigMetadata((QuarkusSecurityIdentity.Builder)builder, (TenantConfigContext)resolvedContext);
            if (result.introspectionResult == null) {
                if (resolvedContext.oidcConfig().token().allowOpaqueTokenIntrospection() && resolvedContext.oidcConfig().token().verifyAccessTokenWithUserInfo().orElse(false).booleanValue()) {
                    userName = resolvedContext.oidcConfig().token().principalClaim().isPresent() && userInfo != null ? userInfo.getString((String)resolvedContext.oidcConfig().token().principalClaim().get()) : "";
                    break block14;
                } else {
                    LOG.debug((Object)"Illegal state - token introspection result is not available.");
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException());
                }
            }
            OidcUtils.setSecurityIdentityIntrospection((QuarkusSecurityIdentity.Builder)builder, (TokenIntrospection)result.introspectionResult);
            String principalName = result.introspectionResult.getUsername();
            if (principalName == null) {
                principalName = result.introspectionResult.getSubject();
            }
            userName = principalName != null ? principalName : "";
            Set scopes = result.introspectionResult.getScopes();
            if (scopes != null) {
                builder.addRoles(scopes);
                OidcUtils.addTokenScopesAsPermissions((QuarkusSecurityIdentity.Builder)builder, (Collection)scopes);
            }
        }
        builder.setPrincipal((Principal)new /* Unavailable Anonymous Inner Class!! */);
        if (userInfo != null) {
            JsonObject rolesJson = new JsonObject(userInfo.getJsonObject().toString());
            OidcUtils.setSecurityIdentityRoles((QuarkusSecurityIdentity.Builder)builder, (OidcTenantConfig)resolvedContext.oidcConfig(), (JsonObject)rolesJson);
            OidcUtils.setSecurityIdentityPermissions((QuarkusSecurityIdentity.Builder)builder, (OidcTenantConfig)resolvedContext.oidcConfig(), (JsonObject)rolesJson);
        }
        OidcUtils.setTenantIdAttribute((QuarkusSecurityIdentity.Builder)builder, (OidcTenantConfig)resolvedContext.oidcConfig());
        RoutingContext vertxContext = HttpSecurityUtils.getRoutingContextAttribute((AuthenticationRequest)request);
        OidcUtils.setBlockingApiAttribute((QuarkusSecurityIdentity.Builder)builder, (RoutingContext)vertxContext);
        OidcUtils.setRoutingContextAttribute((QuarkusSecurityIdentity.Builder)builder, (RoutingContext)vertxContext);
        OidcUtils.setOidcProviderClientAttribute((QuarkusSecurityIdentity.Builder)builder, (OidcProviderClient)resolvedContext.getOidcProviderClient());
        QuarkusSecurityIdentity identity = builder.build();
        if (OidcIdentityProvider.isIdToken(request) && OidcIdentityProvider.tokenAutoRefreshPrepared(result, requestData, resolvedContext.oidcConfig(), false)) {
            return Uni.createFrom().failure((Throwable)new TokenAutoRefreshException((SecurityIdentity)identity));
        }
        return Uni.createFrom().item((Object)identity);
    }

    private static boolean isInternalIdToken(TokenAuthenticationRequest request) {
        return OidcIdentityProvider.isIdToken(request) && ((IdTokenCredential)request.getToken()).isInternal();
    }

    private static boolean isIdToken(TokenAuthenticationRequest request) {
        return request.getToken() instanceof IdTokenCredential;
    }

    private static boolean tokenAutoRefreshPrepared(TokenVerificationResult result, Map<String, Object> requestData, OidcTenantConfig oidcConfig, boolean codeFlowAccessToken) {
        if (result != null && oidcConfig.token().refreshExpired() && oidcConfig.token().refreshTokenTimeSkew().isPresent() && requestData.get(REFRESH_TOKEN_GRANT_RESPONSE) != Boolean.TRUE && requestData.get(NEW_AUTHENTICATION) != Boolean.TRUE) {
            Long expiresIn;
            Long expiry = null;
            if (result.localVerificationResult != null) {
                expiry = result.localVerificationResult.getLong(Claims.exp.name());
            } else if (result.introspectionResult != null) {
                expiry = result.introspectionResult.getLong("exp");
            }
            long now = System.currentTimeMillis() / 1000L;
            if (expiry == null && codeFlowAccessToken && (expiresIn = ((AuthorizationCodeTokens)requestData.get(AuthorizationCodeTokens.class.getName())).getAccessTokenExpiresIn()) != null) {
                expiry = now + expiresIn;
            }
            if (expiry != null) {
                long refreshTokenTimeSkew = ((Duration)oidcConfig.token().refreshTokenTimeSkew().get()).getSeconds();
                return now + refreshTokenTimeSkew > expiry;
            }
        }
        return false;
    }

    private static JsonObject getRolesJson(Map<String, Object> requestData, TenantConfigContext resolvedContext, TokenCredential tokenCred, JsonObject tokenJson, UserInfo userInfo) {
        JsonObject rolesJson = tokenJson;
        if (resolvedContext.oidcConfig().roles().source().isPresent()) {
            if (resolvedContext.oidcConfig().roles().source().get() == OidcTenantConfig.Roles.Source.userinfo) {
                rolesJson = new JsonObject(userInfo.getJsonObject().toString());
            } else if (tokenCred instanceof IdTokenCredential && resolvedContext.oidcConfig().roles().source().get() == OidcTenantConfig.Roles.Source.accesstoken && (rolesJson = ((TokenVerificationResult)requestData.get((Object)"code_flow_access_token_result")).localVerificationResult) == null) {
                rolesJson = OidcCommonUtils.decodeJwtContent((String)((String)requestData.get("access_token")));
            }
        }
        return rolesJson;
    }

    private Uni<TokenVerificationResult> verifyCodeFlowAccessTokenUni(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext, UserInfo userInfo) {
        if (OidcIdentityProvider.isIdToken(request) && (resolvedContext.oidcConfig().authentication().verifyAccessToken() || resolvedContext.oidcConfig().roles().source().orElse(null) == OidcTenantConfig.Roles.Source.accesstoken)) {
            String codeAccessToken = (String)requestData.get("access_token");
            return this.verifyTokenUni(requestData, resolvedContext, (TokenCredential)new AccessTokenCredential(codeAccessToken), false, true, userInfo);
        }
        return NULL_CODE_ACCESS_TOKEN_UNI;
    }

    private Uni<TokenVerificationResult> verifyTokenUni(Map<String, Object> requestData, TenantConfigContext resolvedContext, TokenCredential tokenCred, boolean enforceAudienceVerification, boolean codeFlowAccessToken, UserInfo userInfo) {
        String token = tokenCred.getToken();
        Long expiresIn = null;
        if (codeFlowAccessToken) {
            expiresIn = ((AuthorizationCodeTokens)requestData.get(AuthorizationCodeTokens.class.getName())).getAccessTokenExpiresIn();
        }
        if (OidcUtils.isOpaqueToken((String)token)) {
            if (!resolvedContext.oidcConfig().token().allowOpaqueTokenIntrospection()) {
                LOG.debug((Object)"Token is opaque but the opaque token introspection is not allowed");
                throw new AuthenticationFailedException();
            }
            if (resolvedContext.oidcConfig().token().verifyAccessTokenWithUserInfo().orElse(false).booleanValue() && resolvedContext.provider().getMetadata().getIntrospectionUri() == null) {
                if (userInfo == null) {
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Opaque access token verification failed as user info is null."));
                }
                return Uni.createFrom().item((Object)new TokenVerificationResult(null, null));
            }
            LOG.debug((Object)"Starting the opaque token introspection");
            return this.introspectTokenUni(resolvedContext, token, expiresIn, false);
        }
        if (resolvedContext.provider().getMetadata().getJsonWebKeySetUri() == null || resolvedContext.oidcConfig().token().requireJwtIntrospectionOnly()) {
            LOG.debug((Object)"Starting the JWT token introspection");
            return this.introspectTokenUni(resolvedContext, token, expiresIn, false);
        }
        if (resolvedContext.oidcConfig().jwks().resolveEarly()) {
            String nonce = tokenCred instanceof IdTokenCredential ? (String)requestData.get("nonce") : null;
            try {
                LOG.debug((Object)"Verifying the JWT token with the local JWK keys");
                return Uni.createFrom().item((Object)resolvedContext.provider().verifyJwtToken(token, enforceAudienceVerification, resolvedContext.oidcConfig().token().subjectRequired(), nonce));
            }
            catch (Throwable t) {
                if (t.getCause() instanceof UnresolvableKeyException) {
                    LOG.debug((Object)"No matching JWK key is found, refreshing and repeating the token verification");
                    return this.refreshJwksAndVerifyTokenUni(resolvedContext, token, enforceAudienceVerification, resolvedContext.oidcConfig().token().subjectRequired(), nonce, expiresIn);
                }
                LOG.debugf("Token verification has failed: %s", (Object)t.getMessage());
                return Uni.createFrom().failure(t);
            }
        }
        String nonce = (String)requestData.get("nonce");
        return this.resolveJwksAndVerifyTokenUni(resolvedContext, tokenCred, enforceAudienceVerification, resolvedContext.oidcConfig().token().subjectRequired(), nonce, expiresIn);
    }

    private Uni<TokenVerificationResult> verifySelfSignedTokenUni(TenantConfigContext resolvedContext, String token) {
        try {
            return Uni.createFrom().item((Object)resolvedContext.provider().verifySelfSignedJwtToken(token, (Key)resolvedContext.getInternalIdTokenSecretKey()));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    private Uni<TokenVerificationResult> refreshJwksAndVerifyTokenUni(TenantConfigContext resolvedContext, String token, boolean enforceAudienceVerification, boolean subjectRequired, String nonce, Long expiresIn) {
        return resolvedContext.provider().refreshJwksAndVerifyJwtToken(token, enforceAudienceVerification, subjectRequired, nonce).onFailure(f -> OidcIdentityProvider.fallbackToIntrospectionIfNoMatchingKey(f, resolvedContext)).recoverWithUni(f -> this.introspectTokenUni(resolvedContext, token, expiresIn, true));
    }

    private Uni<TokenVerificationResult> resolveJwksAndVerifyTokenUni(TenantConfigContext resolvedContext, TokenCredential tokenCred, boolean enforceAudienceVerification, boolean subjectRequired, String nonce, Long expiresIn) {
        return resolvedContext.provider().getKeyResolverAndVerifyJwtToken(tokenCred, enforceAudienceVerification, subjectRequired, nonce, tokenCred instanceof IdTokenCredential).onFailure(f -> OidcIdentityProvider.fallbackToIntrospectionIfNoMatchingKey(f, resolvedContext)).recoverWithUni(f -> this.introspectTokenUni(resolvedContext, tokenCred.getToken(), expiresIn, true));
    }

    private static boolean fallbackToIntrospectionIfNoMatchingKey(Throwable f, TenantConfigContext resolvedContext) {
        if (!(f.getCause() instanceof UnresolvableKeyException)) {
            LOG.debug((Object)"Local JWT token verification has failed, skipping the token introspection");
            return false;
        }
        if (!resolvedContext.oidcConfig().token().allowJwtIntrospection()) {
            LOG.debug((Object)"JWT token does not have a matching verification key but JWT token introspection is disabled");
            return false;
        }
        LOG.debug((Object)"Local JWT token verification has failed, attempting the token introspection");
        return true;
    }

    private Uni<TokenVerificationResult> introspectTokenUni(TenantConfigContext resolvedContext, String token, Long expiresIn, boolean fallbackFromJwkMatch) {
        TokenIntrospectionCache tokenIntrospectionCache = this.tenantResolver.getTokenIntrospectionCache();
        Uni tokenIntrospectionUni = tokenIntrospectionCache == null ? null : tokenIntrospectionCache.getIntrospection(token, resolvedContext.oidcConfig(), this.getIntrospectionRequestContext);
        tokenIntrospectionUni = tokenIntrospectionUni == null ? this.newTokenIntrospectionUni(resolvedContext, token, expiresIn, fallbackFromJwkMatch) : tokenIntrospectionUni.onItem().ifNull().switchTo((Supplier)new /* Unavailable Anonymous Inner Class!! */);
        return tokenIntrospectionUni.onItem().transform(t -> new TokenVerificationResult(null, t));
    }

    private Uni<TokenIntrospection> newTokenIntrospectionUni(TenantConfigContext resolvedContext, String token, Long expiresIn, boolean fallbackFromJwkMatch) {
        Uni tokenIntrospectionUni = resolvedContext.provider().introspectToken(token, expiresIn, fallbackFromJwkMatch);
        if (this.tenantResolver.getTokenIntrospectionCache() == null || !resolvedContext.oidcConfig().allowTokenIntrospectionCache()) {
            return tokenIntrospectionUni;
        }
        return tokenIntrospectionUni.call((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static Uni<SecurityIdentity> validateTokenWithoutOidcServer(TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        try {
            TokenVerificationResult result = resolvedContext.provider().verifyJwtToken(request.getToken().getToken(), resolvedContext.oidcConfig().token().subjectRequired(), false, null);
            return Uni.createFrom().item((Object)OidcUtils.validateAndCreateIdentity(Map.of(), (TokenCredential)request.getToken(), (TenantConfigContext)resolvedContext, (JsonObject)result.localVerificationResult, (JsonObject)result.localVerificationResult, null, null, (TokenAuthenticationRequest)request));
        }
        catch (Throwable t) {
            return Uni.createFrom().failure((Throwable)new AuthenticationFailedException(t));
        }
    }

    private Uni<UserInfo> getUserInfoUni(Map<String, Object> requestData, TokenAuthenticationRequest request, TenantConfigContext resolvedContext) {
        JsonObject userInfo;
        if (OidcIdentityProvider.isInternalIdToken(request) && OidcUtils.cacheUserInfoInIdToken((DefaultTenantConfigResolver)this.tenantResolver, (OidcTenantConfig)resolvedContext.oidcConfig()) && (userInfo = OidcCommonUtils.decodeJwtContent((String)request.getToken().getToken()).getJsonObject("userinfo")) != null) {
            return Uni.createFrom().item((Object)new UserInfo(userInfo.encode()));
        }
        LOG.debug((Object)"Requesting UserInfo");
        String contextAccessToken = (String)requestData.get("access_token");
        String accessToken = contextAccessToken != null ? contextAccessToken : request.getToken().getToken();
        UserInfoCache userInfoCache = this.tenantResolver.getUserInfoCache();
        Uni userInfoUni = userInfoCache == null ? null : userInfoCache.getUserInfo(accessToken, resolvedContext.oidcConfig(), this.getUserInfoRequestContext);
        userInfoUni = userInfoUni == null ? this.newUserInfoUni(resolvedContext, accessToken) : userInfoUni.onItem().ifNull().switchTo((Supplier)new /* Unavailable Anonymous Inner Class!! */);
        return userInfoUni;
    }

    private Uni<UserInfo> newUserInfoUni(TenantConfigContext resolvedContext, String accessToken) {
        Uni userInfoUni = resolvedContext.provider().getUserInfo(accessToken);
        if (this.tenantResolver.getUserInfoCache() == null || !resolvedContext.oidcConfig().allowUserInfoCache() || OidcUtils.cacheUserInfoInIdToken((DefaultTenantConfigResolver)this.tenantResolver, (OidcTenantConfig)resolvedContext.oidcConfig())) {
            return userInfoUni;
        }
        return userInfoUni.call((Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public OidcIdentityProvider() {
    }
}

