/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class AddReferencesItem
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=379");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=380");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=381");
    private final NodeId sourceNodeId;
    private final NodeId referenceTypeId;
    private final Boolean isForward;
    private final String targetServerUri;
    private final ExpandedNodeId targetNodeId;
    private final NodeClass targetNodeClass;

    public AddReferencesItem(NodeId sourceNodeId, NodeId referenceTypeId, Boolean isForward, String targetServerUri, ExpandedNodeId targetNodeId, NodeClass targetNodeClass) {
        this.sourceNodeId = sourceNodeId;
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.targetServerUri = targetServerUri;
        this.targetNodeId = targetNodeId;
        this.targetNodeClass = targetNodeClass;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public NodeId getSourceNodeId() {
        return this.sourceNodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public Boolean getIsForward() {
        return this.isForward;
    }

    public String getTargetServerUri() {
        return this.targetServerUri;
    }

    public ExpandedNodeId getTargetNodeId() {
        return this.targetNodeId;
    }

    public NodeClass getTargetNodeClass() {
        return this.targetNodeClass;
    }

    protected AddReferencesItem(AddReferencesItemBuilder<?, ?> b) {
        super(b);
        this.sourceNodeId = ((AddReferencesItemBuilder)b).sourceNodeId;
        this.referenceTypeId = ((AddReferencesItemBuilder)b).referenceTypeId;
        this.isForward = ((AddReferencesItemBuilder)b).isForward;
        this.targetServerUri = ((AddReferencesItemBuilder)b).targetServerUri;
        this.targetNodeId = ((AddReferencesItemBuilder)b).targetNodeId;
        this.targetNodeClass = ((AddReferencesItemBuilder)b).targetNodeClass;
    }

    public static AddReferencesItemBuilder<?, ?> builder() {
        return new AddReferencesItemBuilderImpl();
    }

    public AddReferencesItemBuilder<?, ?> toBuilder() {
        return new AddReferencesItemBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddReferencesItem)) {
            return false;
        }
        AddReferencesItem other = (AddReferencesItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isForward = this.getIsForward();
        Boolean other$isForward = other.getIsForward();
        if (this$isForward == null ? other$isForward != null : !((Object)this$isForward).equals(other$isForward)) {
            return false;
        }
        NodeId this$sourceNodeId = this.getSourceNodeId();
        NodeId other$sourceNodeId = other.getSourceNodeId();
        if (this$sourceNodeId == null ? other$sourceNodeId != null : !((Object)this$sourceNodeId).equals(other$sourceNodeId)) {
            return false;
        }
        NodeId this$referenceTypeId = this.getReferenceTypeId();
        NodeId other$referenceTypeId = other.getReferenceTypeId();
        if (this$referenceTypeId == null ? other$referenceTypeId != null : !((Object)this$referenceTypeId).equals(other$referenceTypeId)) {
            return false;
        }
        String this$targetServerUri = this.getTargetServerUri();
        String other$targetServerUri = other.getTargetServerUri();
        if (this$targetServerUri == null ? other$targetServerUri != null : !this$targetServerUri.equals(other$targetServerUri)) {
            return false;
        }
        ExpandedNodeId this$targetNodeId = this.getTargetNodeId();
        ExpandedNodeId other$targetNodeId = other.getTargetNodeId();
        if (this$targetNodeId == null ? other$targetNodeId != null : !((Object)this$targetNodeId).equals(other$targetNodeId)) {
            return false;
        }
        NodeClass this$targetNodeClass = this.getTargetNodeClass();
        NodeClass other$targetNodeClass = other.getTargetNodeClass();
        return !(this$targetNodeClass == null ? other$targetNodeClass != null : !this$targetNodeClass.equals(other$targetNodeClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddReferencesItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isForward = this.getIsForward();
        result = result * 59 + ($isForward == null ? 43 : ((Object)$isForward).hashCode());
        NodeId $sourceNodeId = this.getSourceNodeId();
        result = result * 59 + ($sourceNodeId == null ? 43 : ((Object)$sourceNodeId).hashCode());
        NodeId $referenceTypeId = this.getReferenceTypeId();
        result = result * 59 + ($referenceTypeId == null ? 43 : ((Object)$referenceTypeId).hashCode());
        String $targetServerUri = this.getTargetServerUri();
        result = result * 59 + ($targetServerUri == null ? 43 : $targetServerUri.hashCode());
        ExpandedNodeId $targetNodeId = this.getTargetNodeId();
        result = result * 59 + ($targetNodeId == null ? 43 : ((Object)$targetNodeId).hashCode());
        NodeClass $targetNodeClass = this.getTargetNodeClass();
        result = result * 59 + ($targetNodeClass == null ? 43 : $targetNodeClass.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AddReferencesItem(sourceNodeId=" + this.getSourceNodeId() + ", referenceTypeId=" + this.getReferenceTypeId() + ", isForward=" + this.getIsForward() + ", targetServerUri=" + this.getTargetServerUri() + ", targetNodeId=" + this.getTargetNodeId() + ", targetNodeClass=" + this.getTargetNodeClass() + ")";
    }

    private static final class AddReferencesItemBuilderImpl
    extends AddReferencesItemBuilder<AddReferencesItem, AddReferencesItemBuilderImpl> {
        private AddReferencesItemBuilderImpl() {
        }

        @Override
        protected AddReferencesItemBuilderImpl self() {
            return this;
        }

        @Override
        public AddReferencesItem build() {
            return new AddReferencesItem(this);
        }
    }

    public static abstract class AddReferencesItemBuilder<C extends AddReferencesItem, B extends AddReferencesItemBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId sourceNodeId;
        private NodeId referenceTypeId;
        private Boolean isForward;
        private String targetServerUri;
        private ExpandedNodeId targetNodeId;
        private NodeClass targetNodeClass;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AddReferencesItemBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(AddReferencesItem instance, AddReferencesItemBuilder<?, ?> b) {
            b.sourceNodeId(instance.sourceNodeId);
            b.referenceTypeId(instance.referenceTypeId);
            b.isForward(instance.isForward);
            b.targetServerUri(instance.targetServerUri);
            b.targetNodeId(instance.targetNodeId);
            b.targetNodeClass(instance.targetNodeClass);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sourceNodeId(NodeId sourceNodeId) {
            this.sourceNodeId = sourceNodeId;
            return (B)this.self();
        }

        public B referenceTypeId(NodeId referenceTypeId) {
            this.referenceTypeId = referenceTypeId;
            return (B)this.self();
        }

        public B isForward(Boolean isForward) {
            this.isForward = isForward;
            return (B)this.self();
        }

        public B targetServerUri(String targetServerUri) {
            this.targetServerUri = targetServerUri;
            return (B)this.self();
        }

        public B targetNodeId(ExpandedNodeId targetNodeId) {
            this.targetNodeId = targetNodeId;
            return (B)this.self();
        }

        public B targetNodeClass(NodeClass targetNodeClass) {
            this.targetNodeClass = targetNodeClass;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AddReferencesItem.AddReferencesItemBuilder(super=" + super.toString() + ", sourceNodeId=" + this.sourceNodeId + ", referenceTypeId=" + this.referenceTypeId + ", isForward=" + this.isForward + ", targetServerUri=" + this.targetServerUri + ", targetNodeId=" + this.targetNodeId + ", targetNodeClass=" + this.targetNodeClass + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<AddReferencesItem> {
        @Override
        public Class<AddReferencesItem> getType() {
            return AddReferencesItem.class;
        }

        @Override
        public AddReferencesItem decode(SerializationContext context, UaDecoder decoder) {
            NodeId sourceNodeId = decoder.readNodeId("SourceNodeId");
            NodeId referenceTypeId = decoder.readNodeId("ReferenceTypeId");
            Boolean isForward = decoder.readBoolean("IsForward");
            String targetServerUri = decoder.readString("TargetServerUri");
            ExpandedNodeId targetNodeId = decoder.readExpandedNodeId("TargetNodeId");
            NodeClass targetNodeClass = decoder.readEnum("TargetNodeClass", NodeClass.class);
            return new AddReferencesItem(sourceNodeId, referenceTypeId, isForward, targetServerUri, targetNodeId, targetNodeClass);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, AddReferencesItem value) {
            encoder.writeNodeId("SourceNodeId", value.getSourceNodeId());
            encoder.writeNodeId("ReferenceTypeId", value.getReferenceTypeId());
            encoder.writeBoolean("IsForward", value.getIsForward());
            encoder.writeString("TargetServerUri", value.getTargetServerUri());
            encoder.writeExpandedNodeId("TargetNodeId", value.getTargetNodeId());
            encoder.writeEnum("TargetNodeClass", value.getTargetNodeClass());
        }
    }
}

