/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.connector.limiter;

import com.google.common.util.concurrent.RateLimiter;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.config.PipeConfig;

public class PipeEndPointRateLimiter {
    private static volatile PipeTaskAgent taskAgent;
    private final String pipeName;
    private final long creationTime;
    private final double bytesPerSecondLimit;
    private final ConcurrentMap<TEndPoint, RateLimiter> endPointRateLimiterMap;

    public PipeEndPointRateLimiter(String pipeName, long creationTime, double bytesPerSecondLimit) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.bytesPerSecondLimit = bytesPerSecondLimit;
        this.endPointRateLimiterMap = new ConcurrentHashMap<TEndPoint, RateLimiter>();
    }

    public static void setTaskAgent(PipeTaskAgent taskAgent) {
        PipeEndPointRateLimiter.taskAgent = taskAgent;
    }

    public void acquire(TEndPoint endPoint, long bytes) {
        if (endPoint == null) {
            return;
        }
        RateLimiter rateLimiter = this.endPointRateLimiterMap.computeIfAbsent(endPoint, e -> RateLimiter.create((double)this.bytesPerSecondLimit));
        while (bytes > 0L) {
            if (bytes > Integer.MAX_VALUE) {
                if (!this.tryAcquireWithPipeCheck(rateLimiter, Integer.MAX_VALUE)) {
                    return;
                }
                bytes -= Integer.MAX_VALUE;
                continue;
            }
            this.tryAcquireWithPipeCheck(rateLimiter, (int)bytes);
            return;
        }
    }

    private boolean tryAcquireWithPipeCheck(RateLimiter rateLimiter, int bytes) {
        while (!rateLimiter.tryAcquire(bytes, (long)PipeConfig.getInstance().getRateLimiterHotReloadCheckIntervalMs(), TimeUnit.MILLISECONDS)) {
            PipeTaskAgent finalTaskAgent = taskAgent;
            if (!Objects.nonNull(finalTaskAgent) || finalTaskAgent.getPipeCreationTime(this.pipeName) == this.creationTime) continue;
            return false;
        }
        return true;
    }
}

