/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaFetchScanNode;

public class DeviceSchemaFetchScanNode
extends SchemaFetchScanNode {
    private final PathPatternTree authorityScope;

    public DeviceSchemaFetchScanNode(PlanNodeId id, PartialPath storageGroup, PathPatternTree patternTree, PathPatternTree authorityScope) {
        super(id, storageGroup, patternTree);
        this.authorityScope = authorityScope;
        this.authorityScope.constructTree();
    }

    public PathPatternTree getAuthorityScope() {
        return this.authorityScope;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.DEVICE_SCHEMA_FETCH_SCAN;
    }

    @Override
    public PlanNode clone() {
        return new DeviceSchemaFetchScanNode(this.getPlanNodeId(), this.storageGroup, this.patternTree, this.authorityScope);
    }

    public String toString() {
        return String.format("DeviceSchemaFetchScanNode-%s:[StorageGroup: %s, DataRegion: %s]", this.getPlanNodeId(), this.storageGroup, PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICE_SCHEMA_FETCH_SCAN.serialize(byteBuffer);
        this.storageGroup.serialize(byteBuffer);
        this.patternTree.serialize(byteBuffer);
        this.authorityScope.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICE_SCHEMA_FETCH_SCAN.serialize(stream);
        this.storageGroup.serialize((OutputStream)stream);
        this.patternTree.serialize(stream);
        this.authorityScope.serialize(stream);
    }

    public static DeviceSchemaFetchScanNode deserialize(ByteBuffer byteBuffer) {
        PartialPath storageGroup = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        PathPatternTree authorityScope = PathPatternTree.deserialize((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new DeviceSchemaFetchScanNode(planNodeId, storageGroup, patternTree, authorityScope);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDeviceSchemaFetchScan(this, context);
    }
}

