/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.resource.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.function.Consumer;

public class PipeLogger {
    private static PipePeriodicalLogger logger = (loggerFunction, rawMessage, formatter) -> loggerFunction.accept(String.format(rawMessage, formatter));

    public static void log(Consumer<String> loggerFunction, String rawMessage, Object ... formatter) {
        logger.log(loggerFunction, rawMessage, formatter);
    }

    public static void log(Consumer<String> loggerFunction, Throwable throwable, String rawMessage, Object ... formatter) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(out));
        logger.log(loggerFunction, rawMessage + "\n" + out, formatter);
    }

    public static void setLogger(PipePeriodicalLogger logger) {
        PipeLogger.logger = logger;
    }

    private PipeLogger() {
    }

    @FunctionalInterface
    public static interface PipePeriodicalLogger {
        public void log(Consumer<String> var1, String var2, Object ... var3);
    }
}

