/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.google.common.collect.ImmutableSet;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.util.Set;
import org.apache.james.transport.mailets.AbstractSign;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sign
extends AbstractSign {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sign.class);

    public String getMailetInfo() {
        return "Signature Mailet";
    }

    @Override
    protected Set<String> getAllowedInitParameters() {
        return ImmutableSet.of((Object)"keyHolderClass", (Object)"debug", (Object)"keyStoreFileName", (Object)"keyStorePassword", (Object)"keyStoreType", (Object)"keyAlias", (Object[])new String[]{"keyAliasPassword", "signerName", "postmasterSigns", "rebuildFrom", "explanationText"});
    }

    @Override
    public String getExplanationText() {
        String explanationText = super.getExplanationText();
        if (explanationText == null) {
            explanationText = "The message this file is attached to has been signed on the server by\r\n\t\"[signerName]\" <[signerAddress]>\r\nto certify that the sender is known and truly has the following address (reverse-path):\r\n\t[reversePath]\r\nand that the original message has the following message headers:\r\n\r\n[headers]\r\n\r\nThe signature envelopes this attachment too.\r\nPlease check the signature integrity.\r\n\r\n\t\"[signerName]\" <[signerAddress]>";
        }
        return explanationText;
    }

    @Override
    protected void initPostmasterSigns() {
        this.setPostmasterSigns(this.getInitParameter("postmasterSigns") == null ? true : Boolean.parseBoolean(this.getInitParameter("postmasterSigns")));
    }

    @Override
    protected void initRebuildFrom() throws MessagingException {
        this.setRebuildFrom(this.getInitParameter("rebuildFrom") == null ? true : Boolean.parseBoolean(this.getInitParameter("rebuildFrom")));
        if (this.isDebug()) {
            if (this.isRebuildFrom()) {
                LOGGER.debug("Will modify the \"From:\" header.");
            } else {
                LOGGER.debug("Will leave the \"From:\" header unchanged.");
            }
        }
    }

    @Override
    protected MimeBodyPart getWrapperBodyPart(Mail mail) throws MessagingException, IOException {
        String explanationText = this.getExplanationText();
        if (explanationText == null) {
            return null;
        }
        MimeMessage originalMessage = mail.getMessage();
        MimeBodyPart messagePart = new MimeBodyPart();
        MimeBodyPart signatureReason = new MimeBodyPart();
        String contentType = originalMessage.getContentType();
        Object content = originalMessage.getContent();
        if (contentType == null || content == null) {
            throw new MessagingException("Either the content type or the content is null");
        }
        messagePart.setContent(content, contentType);
        String headers = this.getMessageHeaders(originalMessage);
        signatureReason.setText(this.getReplacedExplanationText(this.getExplanationText(), this.getSignerName(), this.getKeyHolder().getSignerAddress(), mail.getMaybeSender().asString(), headers));
        signatureReason.setFileName("SignatureExplanation.txt");
        MimeMultipart wrapperMultiPart = new MimeMultipart();
        wrapperMultiPart.addBodyPart((BodyPart)messagePart);
        wrapperMultiPart.addBodyPart((BodyPart)signatureReason);
        MimeBodyPart wrapperBodyPart = new MimeBodyPart();
        wrapperBodyPart.setContent((Multipart)wrapperMultiPart);
        return wrapperBodyPart;
    }
}

