/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.james.mime4j.codec.QuotedPrintableOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class QuotedPrintableOutputStreamTest {
    @Test
    public void testEncode() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        QuotedPrintableOutputStream encoder = new QuotedPrintableOutputStream((OutputStream)bos, false);
        encoder.write(this.fromString("This is the plain text message containing a few euros: 100 \u20ac!"));
        encoder.close();
        Assert.assertEquals((Object)"This is the plain text message containing a few euros: 100 =E2=82=AC!", (Object)this.toString(bos.toByteArray()));
    }

    @Test
    public void testEncodeUnderlyingStreamStaysOpen() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        QuotedPrintableOutputStream encoder = new QuotedPrintableOutputStream((OutputStream)bos, false);
        encoder.write(this.fromString("This is the plain text message containing a few euros: 100 \u20ac!"));
        encoder.close();
        try {
            encoder.write(98);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bos.write(121);
        bos.write(97);
        bos.write(100);
        bos.write(97);
        Assert.assertEquals((Object)"This is the plain text message containing a few euros: 100 =E2=82=AC!yada", (Object)this.toString(bos.toByteArray()));
    }

    @Test
    public void testEncodeSpecials() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        QuotedPrintableOutputStream encoder = new QuotedPrintableOutputStream((OutputStream)bos, false);
        encoder.write(this.fromString("Testing \u20ac special . chars = also at the end ="));
        encoder.close();
        Assert.assertEquals((Object)"Testing =E2=82=AC special =2E chars =3D also at the end =3D", (Object)this.toString(bos.toByteArray()));
    }

    @Test
    public void testEncodeWrapping() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        QuotedPrintableOutputStream encoder = new QuotedPrintableOutputStream((OutputStream)bos, false);
        encoder.write(this.fromString("This is a very very very very very very very very very very very very very very very long line"));
        encoder.close();
        Assert.assertEquals((Object)"This is a very very very very very very very very very very very very very =\r\nvery very long line", (Object)this.toString(bos.toByteArray()));
    }

    private byte[] fromString(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    private String toString(byte[] b) {
        try {
            return new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            Assert.fail((String)e.getMessage());
            return null;
        }
    }
}

