/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultipartStreamTest {
    private static final String BODY = "A Preamble\r\n--1729\r\n\r\nSimple plain text\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSome more text\r\n--1729--\r\n";
    public static final String MESSAGE = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nA Preamble\r\n--1729\r\n\r\nSimple plain text\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSome more text\r\n--1729--\r\n";
    public static final String COMPLEX_MESSAGE = "To: Wile E. Cayote <wile@example.org>\r\nFrom: Road Runner <runner@example.org>\r\nDate: Tue, 19 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=42\r\n\r\nA little preamble\r\n--42\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nRhubard!\r\n--42\r\nContent-Type: message/rfc822\r\n\r\nTo: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nA Preamble\r\n--1729\r\n\r\nSimple plain text\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nSome more text\r\n--1729--\r\n\r\n--42\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nCustard!\r\n--42--\r\n";
    MimeTokenStream parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new MimeTokenStream();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testShouldSupplyInputStreamForSimpleBody() throws Exception {
        this.parser.parse(InputStreams.create((CharSequence)MESSAGE, (Charset)Charsets.US_ASCII));
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        InputStream out = this.parser.getInputStream();
        Assert.assertEquals((Object)BODY, (Object)IOUtils.toString((InputStream)out, (String)"us-ascii"));
        this.checkState(EntityState.T_END_MULTIPART);
    }

    @Test
    public void testInputStreamShouldReadOnlyMessage() throws Exception {
        this.parser.parse(InputStreams.create((CharSequence)COMPLEX_MESSAGE, (Charset)Charsets.US_ASCII));
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        this.checkState(EntityState.T_PREAMBLE);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MESSAGE);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_START_MULTIPART);
        InputStream out = this.parser.getInputStream();
        Assert.assertEquals((Object)BODY, (Object)IOUtils.toString((InputStream)out, (String)"us-ascii"));
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_START_BODYPART);
        this.checkState(EntityState.T_START_HEADER);
        this.checkState(EntityState.T_FIELD);
        this.checkState(EntityState.T_END_HEADER);
        this.checkState(EntityState.T_BODY);
        this.checkState(EntityState.T_END_BODYPART);
        this.checkState(EntityState.T_END_MULTIPART);
        this.checkState(EntityState.T_END_MESSAGE);
        this.checkState(EntityState.T_END_OF_STREAM);
    }

    private void checkState(EntityState state) throws IOException, MimeException {
        Assert.assertEquals((Object)MimeTokenStream.stateToString((EntityState)state), (Object)MimeTokenStream.stateToString((EntityState)this.parser.next()));
    }
}

