/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.locale;

import com.ibm.icu.impl.locale.LSR;
import com.ibm.icu.impl.locale.LocaleDistanceBuilder;
import com.ibm.icu.impl.locale.XLikelySubtags;
import com.ibm.icu.util.BytesTrie;
import com.ibm.icu.util.ULocale;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LocaleDistance {
    private static final int ABOVE_THRESHOLD = 100;
    private static final boolean DEBUG_OUTPUT = false;
    private final BytesTrie trie;
    private final byte[] regionToPartitionsIndex;
    private final String[][] partitionArrays;
    private final Set<LSR> paradigmLSRs;
    private final int defaultLanguageDistance;
    private final int defaultScriptDistance;
    private final int defaultRegionDistance;
    public static final LocaleDistance INSTANCE = LocaleDistanceBuilder.build();

    LocaleDistance(BytesTrie trie, byte[] regionToPartitionsIndex, String[][] partitionArrays, Set<LSR> paradigmLSRs) {
        this.trie = trie;
        this.regionToPartitionsIndex = regionToPartitionsIndex;
        this.partitionArrays = partitionArrays;
        this.paradigmLSRs = paradigmLSRs;
        BytesTrie iter = new BytesTrie(trie);
        BytesTrie.Result result = iter.next(42);
        assert (result == BytesTrie.Result.INTERMEDIATE_VALUE);
        this.defaultLanguageDistance = iter.getValue();
        result = iter.next(42);
        assert (result == BytesTrie.Result.INTERMEDIATE_VALUE);
        this.defaultScriptDistance = iter.getValue();
        result = iter.next(42);
        assert (result.hasValue());
        this.defaultRegionDistance = iter.getValue();
    }

    public int testOnlyDistance(ULocale desired, ULocale supported, int threshold, DistanceOption distanceOption) {
        LSR supportedLSR = XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(supported);
        LSR desiredLSR = XLikelySubtags.INSTANCE.makeMaximizedLsrFrom(desired);
        return this.getBestIndexAndDistance(desiredLSR, new LSR[]{supportedLSR}, threshold, distanceOption) & 0xFF;
    }

    int getBestIndexAndDistance(LSR desired, LSR[] supportedLsrs, int threshold, DistanceOption distanceOption) {
        BytesTrie iter = new BytesTrie(this.trie);
        int desLangDistance = LocaleDistance.trieNext(iter, desired.language, true, true);
        long desLangState = desLangDistance >= 0 && supportedLsrs.length > 1 ? iter.getState64() : 0L;
        int bestIndex = -1;
        for (int slIndex = 0; slIndex < supportedLsrs.length; ++slIndex) {
            boolean scriptFirst;
            LSR supported = supportedLsrs[slIndex];
            boolean star = false;
            int distance = desLangDistance;
            if (distance >= 0) {
                if (slIndex != 0) {
                    iter.resetToState64(desLangState);
                }
                distance = LocaleDistance.trieNext(iter, supported.language, true, true);
            }
            if (distance < 0) {
                distance = desired.language.equals(supported.language) ? 0 : this.defaultLanguageDistance;
                star = true;
            }
            assert (0 <= distance && distance <= 100);
            boolean bl = scriptFirst = distanceOption == DistanceOption.SCRIPT_FIRST;
            if (scriptFirst) {
                distance >>= 2;
            }
            if (distance >= threshold) continue;
            int scriptDistance = star ? (desired.script.equals(supported.script) ? 0 : this.defaultScriptDistance) : LocaleDistance.getDesSuppDistance(iter, iter.getState64(), desired.script, supported.script, false);
            if (scriptFirst) {
                scriptDistance >>= 1;
            }
            if ((distance += scriptDistance) >= threshold) continue;
            if (!desired.region.equals(supported.region)) {
                if (star) {
                    distance += this.defaultRegionDistance;
                } else {
                    long startState = iter.getState64();
                    String[] desiredPartitions = this.partitionsForRegion(desired);
                    String[] supportedPartitions = this.partitionsForRegion(supported);
                    int regionDistance = desiredPartitions.length > 1 || supportedPartitions.length > 1 ? this.getRegionPartitionsDistance(iter, startState, desiredPartitions, supportedPartitions, threshold - distance) : LocaleDistance.getDesSuppDistance(iter, startState, desiredPartitions[0], supportedPartitions[0], true);
                    distance += regionDistance;
                }
            }
            if (distance >= threshold) continue;
            if (distance == 0) {
                return slIndex << 8;
            }
            bestIndex = slIndex;
            threshold = distance;
        }
        return bestIndex >= 0 ? bestIndex << 8 | threshold : -156;
    }

    private int getRegionPartitionsDistance(BytesTrie iter, long startState, String[] desiredPartitions, String[] supportedPartitions, int threshold) {
        int regionDistance = -1;
        for (String dp : desiredPartitions) {
            for (String sp2 : supportedPartitions) {
                int d;
                if (regionDistance >= 0) {
                    iter.resetToState64(startState);
                }
                if (regionDistance >= (d = LocaleDistance.getDesSuppDistance(iter, startState, dp, sp2, true))) continue;
                if (d >= threshold) {
                    return d;
                }
                regionDistance = d;
            }
        }
        assert (regionDistance >= 0);
        return regionDistance;
    }

    private static final int getDesSuppDistance(BytesTrie iter, long startState, String desired, String supported, boolean finalSubtag) {
        int distance = LocaleDistance.trieNext(iter, desired, false, true);
        if (distance >= 0) {
            distance = LocaleDistance.trieNext(iter, supported, true, !finalSubtag);
        }
        if (distance < 0) {
            BytesTrie.Result result = iter.resetToState64(startState).next(42);
            assert (!finalSubtag ? result == BytesTrie.Result.INTERMEDIATE_VALUE : result.hasValue());
            if (!finalSubtag && desired.equals(supported)) {
                distance = 0;
            } else {
                distance = iter.getValue();
                assert (distance >= 0);
            }
        }
        return distance;
    }

    private static final int trieNext(BytesTrie iter, String s2, boolean wantValue, boolean wantNext) {
        BytesTrie.Result result;
        char c;
        if (s2.isEmpty()) {
            return -1;
        }
        int end = s2.length() - 1;
        int i = 0;
        while (true) {
            c = s2.charAt(i);
            assert (c <= '\u007f');
            if (i >= end) break;
            result = iter.next(c);
            if (!result.hasNext()) {
                return -1;
            }
            ++i;
        }
        result = iter.next(c | 0x80);
        if (wantValue) {
            if (wantNext ? result == BytesTrie.Result.INTERMEDIATE_VALUE : result.hasValue()) {
                return iter.getValue();
            }
        } else if (wantNext ? result == BytesTrie.Result.INTERMEDIATE_VALUE : result.hasValue()) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return this.testOnlyGetDistanceTable(true).toString();
    }

    private String[] partitionsForRegion(LSR lsr) {
        byte pIndex = lsr.regionIndex >= 0 ? this.regionToPartitionsIndex[lsr.regionIndex] : (byte)0;
        return this.partitionArrays[pIndex];
    }

    boolean isParadigmLSR(LSR lsr) {
        return this.paradigmLSRs.contains(lsr);
    }

    public int getDefaultScriptDistance() {
        return this.defaultScriptDistance;
    }

    int getDefaultRegionDistance() {
        return this.defaultRegionDistance;
    }

    public Map<String, Integer> testOnlyGetDistanceTable(boolean skipIntermediateMatchPoints) {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        StringBuilder sb = new StringBuilder();
        for (BytesTrie.Entry entry : this.trie) {
            sb.setLength(0);
            int numSubtags = 0;
            int length = entry.bytesLength();
            for (int i = 0; i < length; ++i) {
                byte b = entry.byteAt(i);
                if (b == 42) {
                    sb.append("*-*-");
                    numSubtags += 2;
                    continue;
                }
                if (b >= 0) {
                    sb.append((char)b);
                    continue;
                }
                sb.append((char)(b & 0x7F)).append('-');
                ++numSubtags;
            }
            assert (sb.length() > 0 && sb.charAt(sb.length() - 1) == '-');
            if (skipIntermediateMatchPoints && numSubtags & true) continue;
            sb.setLength(sb.length() - 1);
            String s2 = sb.toString();
            if (!skipIntermediateMatchPoints && s2.endsWith("*-*")) {
                map.put(s2.substring(0, s2.length() - 2), 0);
            }
            map.put(s2, entry.value);
        }
        return map;
    }

    public void testOnlyPrintDistanceTable() {
        for (Map.Entry<String, Integer> mapping : this.testOnlyGetDistanceTable(true).entrySet()) {
            System.out.println(mapping);
        }
    }

    public static enum DistanceOption {
        REGION_FIRST,
        SCRIPT_FIRST;

    }
}

