/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.james.protocols.api.ClientAuth;

public final class Encryption {
    private final SSLContext context;
    private final boolean starttls;
    private final String[] enabledCipherSuites;
    private final ClientAuth clientAuth;

    private Encryption(SSLContext context, boolean starttls, String[] enabledCipherSuites, ClientAuth clientAuth) {
        this.context = context;
        this.starttls = starttls;
        this.enabledCipherSuites = enabledCipherSuites;
        this.clientAuth = clientAuth;
    }

    public static Encryption createTls(SSLContext context) {
        return Encryption.createTls(context, null, ClientAuth.NONE);
    }

    public static Encryption createTls(SSLContext context, String[] enabledCipherSuites, ClientAuth clientAuth) {
        return new Encryption(context, false, enabledCipherSuites, clientAuth);
    }

    public static Encryption createStartTls(SSLContext context) {
        return Encryption.createStartTls(context, null, ClientAuth.NONE);
    }

    public static Encryption createStartTls(SSLContext context, String[] enabledCipherSuites, ClientAuth clientAuth) {
        return new Encryption(context, true, enabledCipherSuites, clientAuth);
    }

    public SSLContext getContext() {
        return this.context;
    }

    public boolean isStartTLS() {
        return this.starttls;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public SSLEngine createSSLEngine() {
        SSLEngine engine = this.context.createSSLEngine();
        String[] cipherSuites = (String[])ArrayUtils.clone((Object[])this.enabledCipherSuites);
        if (cipherSuites != null && cipherSuites.length > 0) {
            engine.setEnabledCipherSuites(cipherSuites);
        }
        if (ClientAuth.NEED.equals((Object)this.clientAuth)) {
            engine.setNeedClientAuth(true);
        }
        if (ClientAuth.WANT.equals((Object)this.clientAuth)) {
            engine.setWantClientAuth(true);
        }
        return engine;
    }
}

