/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.schemabuilder.CreateType;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.utils.ZonedDateTimeRepresentation;

public interface CassandraZonedDateTimeModule {
    public static final String ZONED_DATE_TIME = "zonedDateTime";
    public static final String DATE = "date";
    public static final String TIME_ZONE = "timeZone";
    public static final CassandraModule MODULE = CassandraModule.type("zonedDateTime").statement(statement -> (CreateType)((CreateType)statement.addColumn(DATE, DataType.timestamp())).addColumn(TIME_ZONE, DataType.text())).build();

    public static UDTValue toUDT(UserType zonedDateTimeUserType, ZonedDateTime zonedDateTime) {
        ZonedDateTimeRepresentation representation = ZonedDateTimeRepresentation.fromZonedDateTime(zonedDateTime);
        return (UDTValue)((UDTValue)zonedDateTimeUserType.newValue().setTimestamp(DATE, representation.getDate())).setString(TIME_ZONE, representation.getSerializedZoneId());
    }

    public static Optional<UDTValue> toUDT(UserType zonedDateTimeUserType, Optional<ZonedDateTime> zonedDateTimeOptional) {
        return zonedDateTimeOptional.map(zonedDateTime -> CassandraZonedDateTimeModule.toUDT(zonedDateTimeUserType, zonedDateTime));
    }

    public static Optional<ZonedDateTime> fromUDTOptional(UDTValue value) {
        return Optional.ofNullable(value).map(CassandraZonedDateTimeModule::fromUDT);
    }

    public static ZonedDateTime fromUDT(UDTValue udtValue) {
        return ZonedDateTimeRepresentation.fromDate(udtValue.getTimestamp(DATE), udtValue.getString(TIME_ZONE)).getZonedDateTime();
    }
}

