/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.RemoveObjectClassTaskProperties;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RemoveObjectClassTask
extends Task {
    @NotNull
    static final String REMOVE_OBJECT_CLASS_TASK_CLASS = "com.unboundid.directory.server.tasks.RemoveObjectClassTask";
    @NotNull
    public static final String ATTR_OBJECT_CLASS = "ds-task-remove-object-class-name";
    @NotNull
    public static final String OC_REMOVE_OBJECT_CLASS_TASK = "ds-task-remove-object-class";
    @NotNull
    static final TaskProperty PROPERTY_OBJECT_CLASS = new TaskProperty("ds-task-remove-object-class-name", TaskMessages.INFO_REMOVE_OC_DISPLAY_NAME_ATTRIBUTE_TYPE.get(), TaskMessages.INFO_REMOVE_OC_DESCRIPTION_ATTRIBUTE_TYPE.get(), String.class, true, false, false);
    private static final long serialVersionUID = 457552922409235779L;
    @NotNull
    private final String objectClass;

    RemoveObjectClassTask() {
        this.objectClass = null;
    }

    public RemoveObjectClassTask(@NotNull String objectClass) {
        this(new RemoveObjectClassTaskProperties(objectClass));
    }

    public RemoveObjectClassTask(@NotNull RemoveObjectClassTaskProperties properties) {
        super(properties.getTaskID(), REMOVE_OBJECT_CLASS_TASK_CLASS, properties.getScheduledStartTime(), properties.getDependencyIDs(), properties.getFailedDependencyAction(), properties.getNotifyOnStart(), properties.getNotifyOnCompletion(), properties.getNotifyOnSuccess(), properties.getNotifyOnError(), properties.getAlertOnStart(), properties.getAlertOnSuccess(), properties.getAlertOnError());
        this.objectClass = properties.getObjectClass();
    }

    public RemoveObjectClassTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.objectClass = entry.getAttributeValue(ATTR_OBJECT_CLASS);
        if (this.objectClass == null) {
            throw new TaskException(TaskMessages.ERR_REMOVE_OC_ENTRY_MISSING_OC.get(entry.getDN(), ATTR_OBJECT_CLASS));
        }
    }

    public RemoveObjectClassTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(REMOVE_OBJECT_CLASS_TASK_CLASS, properties);
        String oc = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (!attrName.equals(ATTR_OBJECT_CLASS)) continue;
            oc = RemoveObjectClassTask.parseString(p, values, oc);
        }
        this.objectClass = oc;
        if (this.objectClass == null) {
            throw new TaskException(TaskMessages.ERR_REMOVE_OC_PROPS_MISSING_OC.get(ATTR_OBJECT_CLASS));
        }
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_REMOVE_OC_TASK_NAME.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_REMOVE_OC_TASK_DESCRIPTION.get();
    }

    @NotNull
    public String getObjectClass() {
        return this.objectClass;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_REMOVE_OBJECT_CLASS_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        return Collections.singletonList(new Attribute(ATTR_OBJECT_CLASS, this.objectClass));
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.singletonList(PROPERTY_OBJECT_CLASS);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(20));
        props.put(PROPERTY_OBJECT_CLASS, Collections.singletonList(this.objectClass));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

