/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class JMAPDraftConfiguration {
    private final boolean enabled;
    private final Optional<String> keystore;
    private final Optional<String> privateKey;
    private final Optional<String> certificates;
    private final String keystoreType;
    private final Optional<String> secret;
    private final List<String> jwtPublicKeyPem;
    private final Optional<List<String>> authenticationStrategies;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    JMAPDraftConfiguration(boolean enabled, Optional<String> keystore, Optional<String> privateKey, Optional<String> certificates, String keystoreType, Optional<String> secret, List<String> jwtPublicKeyPem, Optional<List<String>> authenticationStrategies) {
        this.enabled = enabled;
        this.keystore = keystore;
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.keystoreType = keystoreType;
        this.secret = secret;
        this.jwtPublicKeyPem = jwtPublicKeyPem;
        this.authenticationStrategies = authenticationStrategies;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<String> getKeystore() {
        return this.keystore;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public Optional<String> getPrivateKey() {
        return this.privateKey;
    }

    public Optional<String> getCertificates() {
        return this.certificates;
    }

    public Optional<String> getSecret() {
        return this.secret;
    }

    public List<String> getJwtPublicKeyPem() {
        return this.jwtPublicKeyPem;
    }

    public Optional<List<String>> getAuthenticationStrategies() {
        return this.authenticationStrategies;
    }

    public static class Builder {
        private Optional<String> keystore = Optional.empty();
        private Optional<String> keystoreType = Optional.empty();
        private Optional<String> privateKey = Optional.empty();
        private Optional<String> certificates = Optional.empty();
        private Optional<String> secret = Optional.empty();
        private Optional<Boolean> enabled = Optional.empty();
        private ImmutableList.Builder<String> jwtPublicKeyPem = ImmutableList.builder();
        private Optional<List<String>> authenticationStrategies = Optional.empty();

        private Builder() {
        }

        public Builder keystore(String keystore) {
            this.keystore = Optional.ofNullable(keystore).filter(s -> !s.isEmpty());
            return this;
        }

        public Builder privateKey(String privateKey) {
            this.privateKey = Optional.ofNullable(privateKey);
            return this;
        }

        public Builder certificates(String certificates) {
            this.certificates = Optional.ofNullable(certificates);
            return this;
        }

        public Builder keystoreType(String keystoreType) {
            this.keystoreType = Optional.ofNullable(keystoreType);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        public Builder enable() {
            return this.enabled(true);
        }

        public Builder disable() {
            return this.enabled(false);
        }

        public Builder secret(String secret) {
            this.secret = Optional.ofNullable(secret).filter(s -> !s.isEmpty());
            return this;
        }

        public Builder jwtPublicKeyPem(Collection<String> jwtPublicKeyPem) {
            Preconditions.checkNotNull(jwtPublicKeyPem);
            this.jwtPublicKeyPem.addAll(jwtPublicKeyPem);
            return this;
        }

        public Builder authenticationStrategies(Optional<List<String>> authenticationStrategies) {
            this.authenticationStrategies = authenticationStrategies;
            return this;
        }

        public JMAPDraftConfiguration build() {
            Preconditions.checkState((boolean)this.enabled.isPresent(), (Object)"You should specify if JMAP server should be started");
            Preconditions.checkState((this.enabled.get() == false || this.cryptoParametersAreSpecified() ? 1 : 0) != 0, (Object)"('keystore' && 'secret') or (privateKey && certificates) is mandatory");
            return new JMAPDraftConfiguration(this.enabled.get(), this.keystore, this.privateKey, this.certificates, this.keystoreType.orElse("JKS"), this.secret, (List<String>)this.jwtPublicKeyPem.build(), this.authenticationStrategies);
        }

        private boolean cryptoParametersAreSpecified() {
            return this.keystore.isPresent() && this.secret.isPresent() || this.privateKey.isPresent() && this.certificates.isPresent();
        }
    }
}

