/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.vacation.api.Vacation;

public class VacationDTO {
    private final Optional<Boolean> enabled;
    private final Optional<ZonedDateTime> fromDate;
    private final Optional<ZonedDateTime> toDate;
    private final Optional<String> subject;
    private final Optional<String> textBody;
    private final Optional<String> htmlBody;

    public static VacationDTO from(Vacation vacation) {
        Preconditions.checkNotNull((Object)vacation);
        return new VacationDTO(Optional.of(vacation.isEnabled()), vacation.getFromDate(), vacation.getToDate(), vacation.getSubject(), vacation.getTextBody(), vacation.getHtmlBody());
    }

    @JsonCreator
    private VacationDTO(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="fromDate") Optional<ZonedDateTime> fromDate, @JsonProperty(value="toDate") Optional<ZonedDateTime> toDate, @JsonProperty(value="subject") Optional<String> subject, @JsonProperty(value="textBody") Optional<String> textBody, @JsonProperty(value="htmlBody") Optional<String> htmlBody) {
        this.enabled = enabled;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.textBody = textBody;
        this.subject = subject;
        this.htmlBody = htmlBody;
    }

    public Optional<Boolean> getEnabled() {
        return this.enabled;
    }

    public Optional<ZonedDateTime> getFromDate() {
        return this.fromDate;
    }

    public Optional<ZonedDateTime> getToDate() {
        return this.toDate;
    }

    public Optional<String> getTextBody() {
        return this.textBody;
    }

    public Optional<String> getSubject() {
        return this.subject;
    }

    public Optional<String> getHtmlBody() {
        return this.htmlBody;
    }

    public final boolean equals(Object o) {
        if (o instanceof VacationDTO) {
            VacationDTO that = (VacationDTO)o;
            return Objects.equals(this.enabled, that.enabled) && Objects.equals(this.fromDate, that.fromDate) && Objects.equals(this.toDate, that.toDate) && Objects.equals(this.subject, that.subject) && Objects.equals(this.textBody, that.textBody) && Objects.equals(this.htmlBody, that.htmlBody);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.enabled, this.fromDate, this.toDate, this.subject, this.textBody, this.htmlBody);
    }
}

