/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.pop3server.core;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.pop3server.mailbox.MailboxAdapterFactory;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lib.POP3BeforeSMTPHelper;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.core.AbstractPassCmdHandler;
import org.apache.james.protocols.pop3.mailbox.Mailbox;
import org.apache.james.util.MDCBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PassCmdHandler
extends AbstractPassCmdHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PassCmdHandler.class);
    private final MailboxManager manager;
    private final MailboxAdapterFactory mailboxAdapterFactory;

    @Inject
    public PassCmdHandler(@Named(value="mailboxmanager") MailboxManager manager, MailboxAdapterFactory mailboxAdapterFactory, MetricFactory metricFactory) {
        super(metricFactory);
        this.manager = manager;
        this.mailboxAdapterFactory = mailboxAdapterFactory;
    }

    public Response onCommand(POP3Session session, Request request) {
        Response response = super.onCommand(session, request);
        if ("+OK".equals(response.getRetCode())) {
            POP3BeforeSMTPHelper.addIPAddress((String)session.getRemoteAddress().getAddress().getHostAddress());
        }
        return response;
    }

    protected Mailbox auth(POP3Session session, Username username, String password) throws Exception {
        return (Mailbox)MDCBuilder.withMdc((MDCBuilder)MDCBuilder.create().addToContext("user", username.asString()), (Supplier)Throwing.supplier(() -> this.auth(session, password)).sneakyThrow());
    }

    private Mailbox auth(POP3Session session, String password) throws IOException {
        MailboxSession mSession = null;
        try {
            mSession = this.manager.login(session.getUsername(), password);
            session.stopDetectingCommandInjection();
            this.manager.startProcessingRequest(mSession);
            MailboxPath inbox = MailboxPath.inbox((MailboxSession)mSession);
            if (!((Boolean)Mono.from((Publisher)this.manager.mailboxExists(inbox, mSession)).block()).booleanValue()) {
                Optional mailboxId = this.manager.createMailbox(inbox, mSession);
                LOGGER.info("Provisioning INBOX. {} created.", (Object)mailboxId);
            }
            MessageManager mailbox = this.manager.getMailbox(MailboxPath.inbox((MailboxSession)mSession), mSession);
            LOGGER.info("Opening mailbox {} {} with mailbox session {}", new Object[]{mailbox.getId().serialize(), mailbox.getMailboxPath().asString(), mSession.getSessionId().getValue()});
            Mailbox mailbox2 = this.mailboxAdapterFactory.create(mailbox, mSession);
            return mailbox2;
        }
        catch (BadCredentialsException e) {
            LOGGER.info("Bad credential supplied for {} with remote address {}", (Object)session.getUsername().asString(), (Object)session.getRemoteAddress().getAddress());
            Mailbox mailbox = null;
            return mailbox;
        }
        catch (MailboxException e) {
            throw new IOException("Unable to access mailbox for user " + session.getUsername().asString(), e);
        }
        finally {
            if (mSession != null) {
                this.manager.endProcessingRequest(mSession);
            }
        }
    }
}

