/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.response;

import java.util.List;
import java.util.Objects;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.mailbox.model.MailboxACL;

public final class ListRightsResponse
implements ImapResponseMessage {
    private final String identifier;
    private final String mailboxName;
    private final List<MailboxACL.Rfc4314Rights> rights;

    public ListRightsResponse(String mailboxName, String identifier, List<MailboxACL.Rfc4314Rights> rights) {
        this.mailboxName = mailboxName;
        this.identifier = identifier;
        this.rights = rights;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getMailboxName() {
        return this.mailboxName;
    }

    public List<MailboxACL.Rfc4314Rights> getRights() {
        return this.rights;
    }

    public final boolean equals(Object o) {
        if (o instanceof ListRightsResponse) {
            ListRightsResponse other = (ListRightsResponse)o;
            return Objects.equals(this.mailboxName, other.mailboxName) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.rights, other.rights);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxName, this.identifier, this.rights);
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(ImapConstants.LISTRIGHTS_COMMAND.getName()).append(' ').append(this.mailboxName).append(' ').append(this.identifier);
        for (MailboxACL.Rfc4314Rights optionalRightsGroup : this.rights) {
            result.append(' ').append(optionalRightsGroup.toString());
        }
        return result.toString();
    }
}

