/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.stats.ShardRoutingState;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ShardRouting
implements JsonpSerializable {
    private final String node;
    private final boolean primary;
    @Nullable
    private final String relocatingNode;
    private final ShardRoutingState state;
    public static final JsonpDeserializer<ShardRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardRouting::setupShardRoutingDeserializer);

    private ShardRouting(Builder builder) {
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.primary = ApiTypeHelper.requireNonNull(builder.primary, this, "primary");
        this.relocatingNode = builder.relocatingNode;
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
    }

    public static ShardRouting of(Function<Builder, ObjectBuilder<ShardRouting>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String node() {
        return this.node;
    }

    public final boolean primary() {
        return this.primary;
    }

    @Nullable
    public final String relocatingNode() {
        return this.relocatingNode;
    }

    public final ShardRoutingState state() {
        return this.state;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.write(this.node);
        generator.writeKey("primary");
        generator.write(this.primary);
        if (this.relocatingNode != null) {
            generator.writeKey("relocating_node");
            generator.write(this.relocatingNode);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
    }

    protected static void setupShardRoutingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::relocatingNode, JsonpDeserializer.stringDeserializer(), "relocating_node");
        op.add(Builder::state, ShardRoutingState._DESERIALIZER, "state");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardRouting> {
        private String node;
        private Boolean primary;
        @Nullable
        private String relocatingNode;
        private ShardRoutingState state;

        public final Builder node(String value) {
            this.node = value;
            return this;
        }

        public final Builder primary(boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder relocatingNode(@Nullable String value) {
            this.relocatingNode = value;
            return this;
        }

        public final Builder state(ShardRoutingState value) {
            this.state = value;
            return this;
        }

        @Override
        public ShardRouting build() {
            this._checkSingleUse();
            return new ShardRouting(this);
        }
    }
}

