/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import org.apache.james.jspf.core.Inet6Util;
import org.apache.james.jspf.terms.IP4Mechanism;

public class IP6Mechanism
extends IP4Mechanism {
    public static final String REGEX = "[iI][pP][6]\\:([0-9A-Fa-f\\:\\.]+)(?:/(\\d+))?";

    @Override
    protected boolean isValidAddress(String ipString) {
        return Inet6Util.isValidIP6Address(ipString);
    }

    @Override
    protected int getMaxCidr() {
        return 128;
    }

    @Override
    public String toString() {
        if (this.getIp().getMaskLength() == this.getMaxCidr()) {
            return "ip6:" + this.getIp().getIPAddress();
        }
        return "ip6:" + this.getIp().getIPAddress() + "/" + this.getIp().getMaskLength();
    }
}

