/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Null;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetConfigurationExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetConfigurationType;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetConfigurationExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String GET_CONFIG_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.28";
    private static final long serialVersionUID = 2953462215986675988L;
    @NotNull
    private final GetConfigurationType configurationType;
    @Nullable
    private final String fileName;

    public GetConfigurationExtendedRequest(@NotNull ExtendedRequest r) throws LDAPException {
        super(r);
        ASN1OctetString value = r.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CONFIG_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            switch (elements[0].getType()) {
                case -128: {
                    this.configurationType = GetConfigurationType.ACTIVE;
                    this.fileName = null;
                    break;
                }
                case -127: {
                    this.configurationType = GetConfigurationType.BASELINE;
                    this.fileName = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
                    break;
                }
                case -126: {
                    this.configurationType = GetConfigurationType.ARCHIVED;
                    this.fileName = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
                    break;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CONFIG_REQUEST_UNEXPECTED_CONFIG_TYPE.get(StaticUtils.toHex(elements[0].getType())));
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CONFIG_REQUEST_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private GetConfigurationExtendedRequest(@NotNull GetConfigurationType configurationType, @Nullable String fileName, Control ... controls) {
        super(GET_CONFIG_REQUEST_OID, GetConfigurationExtendedRequest.encodeValue(configurationType, fileName), controls);
        this.configurationType = configurationType;
        this.fileName = fileName;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull GetConfigurationType configurationType, @Nullable String fileName) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(0);
        switch (configurationType) {
            case ACTIVE: {
                elements.add(new ASN1Null(configurationType.getBERType()));
                break;
            }
            case BASELINE: 
            case ARCHIVED: {
                elements.add(new ASN1OctetString(configurationType.getBERType(), fileName));
                break;
            }
            default: {
                return null;
            }
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public static GetConfigurationExtendedRequest createGetActiveConfigurationRequest(Control ... controls) {
        return new GetConfigurationExtendedRequest(GetConfigurationType.ACTIVE, null, controls);
    }

    @NotNull
    public static GetConfigurationExtendedRequest createGetBaselineConfigurationRequest(@NotNull String fileName, Control ... controls) {
        Validator.ensureNotNull(fileName);
        return new GetConfigurationExtendedRequest(GetConfigurationType.BASELINE, fileName, controls);
    }

    @NotNull
    public static GetConfigurationExtendedRequest createGetArchivedConfigurationRequest(@NotNull String fileName, Control ... controls) {
        Validator.ensureNotNull(fileName);
        return new GetConfigurationExtendedRequest(GetConfigurationType.ARCHIVED, fileName, controls);
    }

    @NotNull
    public GetConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @NotNull
    public GetConfigurationExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new GetConfigurationExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public GetConfigurationExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public GetConfigurationExtendedRequest duplicate(@Nullable Control[] controls) {
        GetConfigurationExtendedRequest r = new GetConfigurationExtendedRequest(this.configurationType, this.fileName, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_GET_CONFIG.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        Control[] controls;
        buffer.append("GetConfigurationsExtendedRequest(configType=");
        buffer.append(this.configurationType.name());
        if (this.fileName != null) {
            buffer.append(", fileName='");
            buffer.append(this.fileName);
            buffer.append('\'');
        }
        if ((controls = this.getControls()).length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

