/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedToken;
import com.datastax.oss.driver.internal.core.metadata.token.ByteOrderedTokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.protocol.internal.util.Bytes;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ByteOrderedTokenFactory
implements TokenFactory {
    public static final String PARTITIONER_NAME = "org.apache.cassandra.dht.ByteOrderedPartitioner";
    public static final ByteOrderedToken MIN_TOKEN = new ByteOrderedToken(ByteBuffer.allocate(0));

    @Override
    public String getPartitionerName() {
        return PARTITIONER_NAME;
    }

    @Override
    public Token hash(ByteBuffer partitionKey) {
        return new ByteOrderedToken(partitionKey);
    }

    @Override
    public Token parse(String tokenString) {
        if (!tokenString.startsWith("0x")) {
            String prefix = tokenString.length() % 2 == 0 ? "0x" : "0x0";
            tokenString = prefix + tokenString;
        }
        ByteBuffer value = Bytes.fromHexString((String)tokenString);
        return new ByteOrderedToken(value);
    }

    @Override
    public String format(Token token) {
        Preconditions.checkArgument((boolean)(token instanceof ByteOrderedToken), (Object)"Can only format ByteOrderedToken instances");
        return Bytes.toHexString((ByteBuffer)((ByteOrderedToken)token).getValue());
    }

    @Override
    public Token minToken() {
        return MIN_TOKEN;
    }

    @Override
    public TokenRange range(Token start, Token end) {
        Preconditions.checkArgument((start instanceof ByteOrderedToken && end instanceof ByteOrderedToken ? 1 : 0) != 0, (Object)"Can only build ranges of ByteOrderedToken instances");
        return new ByteOrderedTokenRange((ByteOrderedToken)start, (ByteOrderedToken)end);
    }
}

