/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.incubator.quic;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;
import io.netty.incubator.codec.quic.QuicSslEngine;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ChannelPipelineConfigurer;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.incubator.quic.QuicInbound;
import reactor.netty.incubator.quic.QuicInboundStreamOperations;
import reactor.netty.incubator.quic.QuicInboundStreamTrafficHandler;
import reactor.netty.incubator.quic.QuicInitialSettingsSpec;
import reactor.netty.incubator.quic.QuicOperations;
import reactor.netty.incubator.quic.QuicOutbound;
import reactor.netty.incubator.quic.QuicOutboundStreamOperations;
import reactor.netty.incubator.quic.QuicOutboundStreamTrafficHandler;
import reactor.netty.incubator.quic.QuicResources;
import reactor.netty.incubator.quic.QuicStreamOperations;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.TransportConfig;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

abstract class QuicTransportConfig<CONF extends TransportConfig>
extends TransportConfig {
    static final long DEFAULT_ACK_DELAY_EXPONENT = 3L;
    static final boolean DEFAULT_ACTIVE_MIGRATION = true;
    static final boolean DEFAULT_GREASE = true;
    static final boolean DEFAULT_HYSTART = true;
    static final QuicInitialSettingsSpec DEFAULT_INITIAL_SETTINGS = new QuicInitialSettingsSpec.Build().build();
    static final int DEFAULT_LOCAL_CONNECTION_ID_LENGTH = 20;
    static final Duration DEFAULT_MAX_ACK_DELAY = Duration.ofMillis(25L);
    static final long DEFAULT_MAX_RECV_UDP_PAYLOAD_SIZE = 65527L;
    static final long DEFAULT_MAX_SEND_UDP_PAYLOAD_SIZE = 1200L;
    long ackDelayExponent;
    boolean activeMigration;
    QuicCongestionControlAlgorithm congestionControlAlgorithm;
    Consumer<? super CONF> doOnBind;
    Consumer<? super Connection> doOnBound;
    Consumer<? super Connection> doOnUnbound;
    boolean grease;
    boolean hystart;
    Duration idleTimeout;
    QuicInitialSettingsSpec initialSettings;
    int localConnectionIdLength;
    Duration maxAckDelay;
    long maxRecvUdpPayloadSize;
    long maxSendUdpPayloadSize;
    int recvQueueLen;
    int sendQueueLen;
    Function<QuicChannel, ? extends QuicSslEngine> sslEngineProvider;
    Map<AttributeKey<?>, ?> streamAttrs;
    BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler;
    ConnectionObserver streamObserver;
    Map<ChannelOption<?>, ?> streamOptions;
    static final Logger log = Loggers.getLogger(QuicTransportConfig.class);

    QuicTransportConfig(Map<ChannelOption<?>, ?> options, Map<ChannelOption<?>, ?> streamOptions, Supplier<? extends SocketAddress> bindAddress) {
        super(options, bindAddress);
        this.ackDelayExponent = 3L;
        this.activeMigration = true;
        this.congestionControlAlgorithm = QuicCongestionControlAlgorithm.CUBIC;
        this.grease = true;
        this.hystart = true;
        this.initialSettings = DEFAULT_INITIAL_SETTINGS;
        this.localConnectionIdLength = 20;
        this.maxAckDelay = DEFAULT_MAX_ACK_DELAY;
        this.maxRecvUdpPayloadSize = 65527L;
        this.maxSendUdpPayloadSize = 1200L;
        this.streamAttrs = Collections.emptyMap();
        this.streamObserver = ConnectionObserver.emptyListener();
        this.streamOptions = Objects.requireNonNull(streamOptions, "streamOptions");
    }

    QuicTransportConfig(QuicTransportConfig<CONF> parent) {
        super(parent);
        this.ackDelayExponent = parent.ackDelayExponent;
        this.activeMigration = parent.activeMigration;
        this.congestionControlAlgorithm = parent.congestionControlAlgorithm;
        this.doOnBind = parent.doOnBind;
        this.doOnBound = parent.doOnBound;
        this.doOnUnbound = parent.doOnUnbound;
        this.grease = parent.grease;
        this.hystart = parent.hystart;
        this.idleTimeout = parent.idleTimeout;
        this.initialSettings = parent.initialSettings;
        this.localConnectionIdLength = parent.localConnectionIdLength;
        this.maxAckDelay = parent.maxAckDelay;
        this.maxRecvUdpPayloadSize = parent.maxRecvUdpPayloadSize;
        this.maxSendUdpPayloadSize = parent.maxSendUdpPayloadSize;
        this.recvQueueLen = parent.recvQueueLen;
        this.sendQueueLen = parent.sendQueueLen;
        this.sslEngineProvider = parent.sslEngineProvider;
        this.streamAttrs = parent.streamAttrs;
        this.streamHandler = parent.streamHandler;
        this.streamObserver = parent.streamObserver;
        this.streamOptions = parent.streamOptions;
    }

    public final long ackDelayExponent() {
        return this.ackDelayExponent;
    }

    public final QuicCongestionControlAlgorithm congestionControlAlgorithm() {
        return this.congestionControlAlgorithm;
    }

    @Nullable
    public final Consumer<? super CONF> doOnBind() {
        return this.doOnBind;
    }

    @Nullable
    public final Consumer<? super Connection> doOnBound() {
        return this.doOnBound;
    }

    @Nullable
    public final Consumer<? super Connection> doOnUnbound() {
        return this.doOnUnbound;
    }

    @Nullable
    public final Duration idleTimeout() {
        return this.idleTimeout;
    }

    public final QuicInitialSettingsSpec initialSettings() {
        return this.initialSettings;
    }

    public final boolean isActiveMigration() {
        return this.activeMigration;
    }

    public final boolean isGrease() {
        return this.grease;
    }

    public final boolean isHystart() {
        return this.hystart;
    }

    public final int localConnectionIdLength() {
        return this.localConnectionIdLength;
    }

    public final Duration maxAckDelay() {
        return this.maxAckDelay;
    }

    public final long maxRecvUdpPayloadSize() {
        return this.maxRecvUdpPayloadSize;
    }

    public final long maxSendUdpPayloadSize() {
        return this.maxSendUdpPayloadSize;
    }

    public final int recvQueueLen() {
        return this.recvQueueLen;
    }

    public final int sendQueueLen() {
        return this.sendQueueLen;
    }

    public final Map<AttributeKey<?>, ?> streamAttributes() {
        if (this.streamAttrs == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.streamAttrs);
    }

    public final ConnectionObserver streamObserver() {
        return this.streamObserver;
    }

    public final Map<ChannelOption<?>, ?> streamOptions() {
        if (this.streamOptions == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.streamOptions);
    }

    protected final Class<? extends Channel> channelType(boolean isDomainSocket) {
        if (isDomainSocket) {
            throw new UnsupportedOperationException();
        }
        return DatagramChannel.class;
    }

    protected ConnectionObserver defaultConnectionObserver() {
        if (this.channelGroup() == null && this.doOnBound() == null && this.doOnUnbound() == null) {
            return ConnectionObserver.emptyListener();
        }
        return new QuicTransportDoOn(this.channelGroup(), this.doOnBound(), this.doOnUnbound());
    }

    protected final LoopResources defaultLoopResources() {
        return QuicResources.get();
    }

    protected ChannelPipelineConfigurer defaultOnChannelInit() {
        return new QuicChannelInitializer(this);
    }

    protected final EventLoopGroup eventLoopGroup() {
        return this.loopResources().onClient(this.isPreferNative());
    }

    protected abstract ChannelInitializer<Channel> parentChannelInitializer();

    protected static <K, V> Map<K, V> updateMap(Map<K, V> parentMap, Object key, @Nullable Object value) {
        return TransportConfig.updateMap(parentMap, (Object)key, (Object)value);
    }

    static ChannelInitializer<QuicStreamChannel> streamChannelInitializer(@Nullable ChannelHandler loggingHandler, ConnectionObserver streamListener, boolean inbound) {
        return new QuicStreamChannelInitializer(loggingHandler, streamListener, inbound);
    }

    static final class QuicTransportDoOn
    implements ConnectionObserver {
        final Consumer<? super Connection> doOnBound;
        final Consumer<? super Connection> doOnUnbound;

        QuicTransportDoOn(@Nullable ChannelGroup channelGroup, @Nullable Consumer<? super Connection> doOnBound, @Nullable Consumer<? super Connection> doOnUnbound) {
            this.doOnBound = doOnBound;
            this.doOnUnbound = doOnUnbound;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (this.doOnBound != null && newState == ConnectionObserver.State.CONFIGURED) {
                this.doOnBound.accept((Connection)connection);
                return;
            }
            if (this.doOnUnbound != null && newState == ConnectionObserver.State.DISCONNECTING) {
                connection.onDispose(() -> this.doOnUnbound.accept((Connection)connection));
            }
        }
    }

    static final class QuicStreamChannelObserver
    implements ConnectionObserver {
        final BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler;

        QuicStreamChannelObserver(@Nullable BiFunction<? super QuicInbound, ? super QuicOutbound, ? extends Publisher<Void>> streamHandler) {
            this.streamHandler = streamHandler;
        }

        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (newState == ConnectionObserver.State.CONFIGURED) {
                if (this.streamHandler == null) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)connection.channel(), (String)"IO handler for incoming streams is not specified, the incoming stream is closed."));
                    }
                    connection.channel().close();
                    return;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)connection.channel(), (String)"Handler is being applied: {}"), new Object[]{this.streamHandler});
                    }
                    QuicStreamOperations ops = (QuicStreamOperations)connection;
                    Mono.fromDirect(this.streamHandler.apply(ops, ops)).subscribe(ops.disposeSubscriber());
                }
                catch (Throwable t) {
                    log.error(ReactorNetty.format((Channel)connection.channel(), (String)""), t);
                    connection.channel().close();
                }
            }
        }
    }

    static final class QuicStreamChannelInitializer
    extends ChannelInitializer<QuicStreamChannel> {
        final ChannelHandler loggingHandler;
        final ConnectionObserver streamListener;
        final boolean inbound;

        QuicStreamChannelInitializer(@Nullable ChannelHandler loggingHandler, ConnectionObserver streamListener, boolean inbound) {
            this.loggingHandler = loggingHandler;
            this.streamListener = streamListener;
            this.inbound = inbound;
        }

        protected void initChannel(QuicStreamChannel ch) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)ch, (String)"Created a new QUIC stream."));
            }
            if (this.loggingHandler != null) {
                ch.pipeline().addLast(new ChannelHandler[]{this.loggingHandler});
            }
            if (this.inbound) {
                ch.pipeline().addLast(new ChannelHandler[]{new QuicInboundStreamTrafficHandler()});
                ChannelOperations.addReactiveBridge((Channel)ch, (conn, observer, msg) -> new QuicInboundStreamOperations(conn, observer), (ConnectionObserver)this.streamListener);
            } else {
                ch.pipeline().addLast(new ChannelHandler[]{new QuicOutboundStreamTrafficHandler()});
                ChannelOperations.addReactiveBridge((Channel)ch, (conn, observer, msg) -> new QuicOutboundStreamOperations(conn, observer), (ConnectionObserver)this.streamListener);
            }
        }
    }

    static final class QuicChannelInitializer
    implements ChannelPipelineConfigurer {
        final ChannelHandler loggingHandler;
        final Map<AttributeKey<?>, ?> streamAttrs;
        final ConnectionObserver streamObserver;
        final Map<ChannelOption<?>, ?> streamOptions;

        QuicChannelInitializer(QuicTransportConfig<?> config) {
            this.loggingHandler = config.loggingHandler();
            this.streamAttrs = config.streamAttrs;
            this.streamObserver = config.streamObserver;
            this.streamOptions = config.streamOptions;
        }

        public void onChannelInit(ConnectionObserver observer, Channel channel, @Nullable SocketAddress remoteAddress) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)channel, (String)"Created a new QUIC channel."));
            }
            channel.pipeline().remove("reactor.right.reactiveBridge");
            channel.pipeline().addLast("reactor.right.reactiveBridge", (ChannelHandler)new QuicChannelInboundHandler(observer, this.loggingHandler, this.streamAttrs, this.streamObserver, this.streamOptions));
        }
    }

    static final class QuicChannelInboundHandler
    extends ChannelInboundHandlerAdapter {
        final ConnectionObserver listener;
        final ChannelHandler loggingHandler;
        final Map<AttributeKey<?>, ?> streamAttrs;
        final ConnectionObserver streamObserver;
        final Map<ChannelOption<?>, ?> streamOptions;

        QuicChannelInboundHandler(ConnectionObserver listener, @Nullable ChannelHandler loggingHandler, Map<AttributeKey<?>, ?> streamAttrs, ConnectionObserver streamObserver, Map<ChannelOption<?>, ?> streamOptions) {
            this.listener = listener;
            this.loggingHandler = loggingHandler;
            this.streamAttrs = streamAttrs;
            this.streamObserver = streamObserver;
            this.streamOptions = streamOptions;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            if (ctx.channel().isActive()) {
                Connection c = Connection.from((Channel)ctx.channel());
                this.listener.onStateChange(c, ConnectionObserver.State.CONNECTED);
                QuicOperations ops = new QuicOperations((QuicChannel)ctx.channel(), this.loggingHandler, this.streamObserver, this.streamAttrs, this.streamOptions);
                ops.bind();
                this.listener.onStateChange((Connection)ops, ConnectionObserver.State.CONFIGURED);
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            Connection connection = Connection.from((Channel)ctx.channel());
            this.listener.onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Connection connection = Connection.from((Channel)ctx.channel());
            this.listener.onUncaughtException(connection, cause);
        }
    }
}

