/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.contextpropagation;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ObservationAwareSpanThreadLocalAccessor
implements ThreadLocalAccessor<Span> {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(ObservationAwareSpanThreadLocalAccessor.class);
    final Map<Thread, SpanAction> spanActions = new ConcurrentHashMap<Thread, SpanAction>();
    public static final String KEY = "micrometer.tracing";
    private final ObservationRegistry registry;
    private final Tracer tracer;

    public ObservationAwareSpanThreadLocalAccessor(Tracer tracer) {
        this(ObservationRegistry.create(), tracer);
    }

    public ObservationAwareSpanThreadLocalAccessor(ObservationRegistry observationRegistry, Tracer tracer) {
        this.registry = Objects.requireNonNull(observationRegistry, "observationRegistry must not be null");
        this.tracer = Objects.requireNonNull(tracer, "tracer must not be null");
    }

    public Object key() {
        return KEY;
    }

    public Span getValue() {
        Observation currentObservation = this.registry.getCurrentObservation();
        Span currentSpan = this.tracer.currentSpan();
        if (currentObservation != null) {
            TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)currentObservation.getContext().getOrDefault(TracingObservationHandler.TracingContext.class, (Object)new TracingObservationHandler.TracingContext());
            if (currentSpan != null && !currentSpan.equals(tracingContext.getSpan())) {
                if (log.isTraceEnabled()) {
                    log.trace("User created child spans manually and scoped them, returning [" + currentSpan + "]");
                }
                return currentSpan;
            }
            if (log.isTraceEnabled()) {
                log.trace("Span created by OTLA, falling back to [null]");
            }
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("No span created by OTLA, retrieving current span from tracer [" + currentSpan + "]");
        }
        return currentSpan;
    }

    public void setValue(Span value) {
        if (log.isTraceEnabled()) {
            log.trace("Setting value [" + value + "], current span [" + this.tracer.currentSpan() + "]");
        }
        SpanAction spanAction = this.spanActions.get(Thread.currentThread());
        Tracer.SpanInScope scope = this.tracer.withSpan(value);
        if (log.isTraceEnabled()) {
            log.trace("New scope created [" + scope + "], current span [" + value + "]");
        }
        SpanAction newSpanAction = new SpanAction(this.spanActions, spanAction);
        this.spanActions.put(Thread.currentThread(), newSpanAction);
        newSpanAction.setScope(scope);
    }

    public void setValue() {
        SpanAction spanAction;
        if (log.isTraceEnabled()) {
            log.trace("Setting null value, current span [" + this.tracer.currentSpan() + "]");
        }
        if ((spanAction = this.spanActions.get(Thread.currentThread())) == null) {
            if (log.isTraceEnabled()) {
                log.trace("No action to perform");
            }
            return;
        }
        Tracer.SpanInScope scope = this.tracer.withSpan(null);
        if (log.isTraceEnabled()) {
            log.trace("Null scope created");
        }
        spanAction.setScope(scope);
    }

    public void restore(Span previousValue) {
        SpanAction spanAction;
        if (log.isTraceEnabled()) {
            log.trace("Restoring previous value [" + previousValue + "]");
        }
        if ((spanAction = this.spanActions.get(Thread.currentThread())) == null) {
            if (log.isTraceEnabled()) {
                log.trace("No action to perform");
            }
            return;
        }
        spanAction.close();
        Span currentSpan = this.tracer.currentSpan();
        if (!previousValue.equals(currentSpan)) {
            String msg = "After closing the scope, current span <" + currentSpan + "> is not the same as the one to which you want to revert <" + previousValue + ">. Most likely you've opened a scope and forgotten to close it";
            log.warn(msg);
            assert (false) : msg;
        }
    }

    public void restore() {
        SpanAction spanAction;
        if (log.isTraceEnabled()) {
            log.trace("Restoring to empty span scope");
        }
        if ((spanAction = this.spanActions.get(Thread.currentThread())) != null) {
            spanAction.close();
        } else if (log.isTraceEnabled()) {
            log.trace("No action to perform");
        }
    }

    static class SpanAction
    implements AutoCloseable {
        final SpanAction previous;
        final Map<Thread, SpanAction> todo;
        AutoCloseable scope;

        SpanAction(Map<Thread, SpanAction> spanActions, SpanAction previous) {
            this.previous = previous;
            this.todo = spanActions;
        }

        void setScope(Closeable scope) {
            this.scope = scope;
        }

        @Override
        public void close() {
            if (this.scope != null) {
                try {
                    this.scope.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.previous != null) {
                this.todo.put(Thread.currentThread(), this.previous);
            } else {
                this.todo.remove(Thread.currentThread());
            }
        }
    }
}

