/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.internet.AddressException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.util.StreamUtils;
import org.slf4j.LoggerFactory;

public class Envelope {
    private final MaybeSender from;
    private final Set<MailAddress> recipients;

    public static Envelope fromMime4JMessage(Message mime4JMessage) {
        return Envelope.fromMime4JMessage(mime4JMessage, ValidationPolicy.THROW);
    }

    public static Envelope fromMime4JMessage(Message mime4JMessage, ValidationPolicy validationPolicy) {
        MaybeSender sender = Optional.ofNullable(mime4JMessage.getFrom()).map(Collection::stream).orElse(Stream.empty()).findAny().map(Mailbox::getAddress).flatMap(addressAsString -> Envelope.newMailAddress(validationPolicy, addressAsString)).map(MaybeSender::of).orElse(MaybeSender.nullSender());
        Stream<MailAddress> to = Envelope.emailersToMailAddresses(mime4JMessage.getTo(), validationPolicy);
        Stream<MailAddress> cc = Envelope.emailersToMailAddresses(mime4JMessage.getCc(), validationPolicy);
        Stream<MailAddress> bcc = Envelope.emailersToMailAddresses(mime4JMessage.getBcc(), validationPolicy);
        return new Envelope(sender, (Set)StreamUtils.flatten(Stream.of(to, cc, bcc)).collect(ImmutableSet.toImmutableSet()));
    }

    private static Optional<MailAddress> newMailAddress(ValidationPolicy validationPolicy, String addressAsString) {
        try {
            if (addressAsString.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new MailAddress(addressAsString));
        }
        catch (AddressException e) {
            return validationPolicy.handleParsingException(e);
        }
    }

    private static Stream<MailAddress> emailersToMailAddresses(AddressList addresses, ValidationPolicy validationPolicy) {
        return Optional.ofNullable(addresses).map(AddressList::flatten).map(Collection::stream).orElse(Stream.of(new Mailbox[0])).map(Mailbox::getAddress).map(addressAsString -> Envelope.newMailAddress(validationPolicy, addressAsString)).flatMap(Optional::stream);
    }

    public Envelope(MaybeSender from, Set<MailAddress> recipients) {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull(recipients);
        this.from = from;
        this.recipients = recipients;
    }

    public MaybeSender getFrom() {
        return this.from;
    }

    public Set<MailAddress> getRecipients() {
        return this.recipients;
    }

    public final boolean equals(Object o) {
        if (o instanceof Envelope) {
            Envelope envelope = (Envelope)o;
            return Objects.equals(this.from, envelope.from) && Objects.equals(this.recipients, envelope.recipients);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.from, this.recipients);
    }

    public static interface ValidationPolicy {
        public static final ValidationPolicy THROW = e -> {
            throw new RuntimeException((Throwable)e);
        };
        public static final ValidationPolicy IGNORE = e -> {
            LoggerFactory.getLogger(Envelope.class).info("Failed to parse a mail address", (Throwable)e);
            return Optional.empty();
        };

        public Optional<MailAddress> handleParsingException(AddressException var1);
    }
}

