/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq.metric;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.activemq.ActiveMQConfiguration;
import org.apache.james.queue.activemq.metric.ActiveMQMetricCollector;
import org.apache.james.queue.activemq.metric.ActiveMQMetricConfiguration;
import org.apache.james.queue.activemq.metric.ActiveMQMetrics;
import org.apache.james.queue.api.MailQueueName;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ActiveMQMetricCollectorImpl
implements ActiveMQMetricCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQMetricCollectorImpl.class);
    private final ActiveMQMetricConfiguration config;
    private final ConnectionFactory connectionFactory;
    private final MetricFactory metricFactory;
    private final GaugeRegistry gaugeRegistry;
    private final Map<String, ActiveMQMetrics> registeredStatistics = new HashMap<String, ActiveMQMetrics>();
    private Disposable disposable;

    @Inject
    public ActiveMQMetricCollectorImpl(ActiveMQConfiguration activeMQConfiguration, ConnectionFactory connectionFactory, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.config = activeMQConfiguration.getMetricConfiguration();
        this.connectionFactory = connectionFactory;
        this.metricFactory = metricFactory;
        this.gaugeRegistry = gaugeRegistry;
    }

    @Override
    public void collectBrokerStatistics() {
        this.collectStatistics(ActiveMQMetrics.forBroker(this.gaugeRegistry));
    }

    @Override
    public void collectQueueStatistics(MailQueueName name) {
        this.collectStatistics(ActiveMQMetrics.forQueue(name.asString(), this.gaugeRegistry));
    }

    private void collectStatistics(ActiveMQMetrics statistics) {
        if (this.config.isEnabled() && !this.registeredStatistics.containsKey(statistics.getName())) {
            LOGGER.info("collecting statistics for {}", (Object)statistics.getName());
            this.registeredStatistics.put(statistics.getName(), statistics);
        }
    }

    @Override
    public void start() {
        if (!this.config.isEnabled()) {
            LOGGER.info("collecting statistics disabled");
            return;
        }
        this.collectBrokerStatistics();
        LOGGER.info("start delay={} interval={} timeout={} aqmp_timeout={}", new Object[]{this.config.getStartDelay(), this.config.getInterval(), this.config.getTimeout(), this.config.getAqmpTimeout()});
        this.disposable = Flux.interval((Duration)this.config.getStartDelay(), (Duration)this.config.getInterval()).flatMap(any -> Flux.fromStream(() -> this.registeredStatistics.values().stream()).flatMap(s -> {
            Mono task = Mono.fromCallable(() -> this.fetchAndUpdate((ActiveMQMetrics)s)).timeout(this.config.getTimeout());
            return this.metricFactory.decoratePublisherWithTimerMetric(s.getName() + "._time", (Publisher)task);
        })).onErrorContinue(this::logError).subscribeOn(Schedulers.newSingle((String)ActiveMQMetricCollectorImpl.class.getSimpleName())).subscribe();
    }

    @Override
    @PreDestroy
    public void stop() {
        this.disposable.dispose();
    }

    private Void logError(Throwable error, Object triggeringValue) {
        LOGGER.warn("failed to fetch and update broker statistics", error);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Void fetchAndUpdate(ActiveMQMetrics stats) throws JMSException {
        Connection connection = null;
        Session session = null;
        TemporaryQueue replyTo = null;
        MessageConsumer consumer = null;
        MessageProducer producer = null;
        try {
            connection = this.connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, 1);
            replyTo = session.createTemporaryQueue();
            consumer = session.createConsumer((Destination)replyTo);
            Queue testQueue = session.createQueue(stats.getName());
            producer = session.createProducer((Destination)testQueue);
            Message msg = session.createMessage();
            msg.setJMSReplyTo((Destination)replyTo);
            producer.send(msg);
            long timeoutMs = this.config.getAqmpTimeout().toMillis();
            Message reply = consumer.receive(timeoutMs);
            if (reply == null) {
                throw new JMSException("no message received, timed out after " + timeoutMs + " ms");
            }
            if (!(reply instanceof MapMessage)) {
                throw new JMSException("expected MapMessage but got " + String.valueOf(reply.getClass()));
            }
            stats.updateMetrics((MapMessage)reply);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException jMSException) {}
            }
            if (consumer != null) {
                try {
                    consumer.close();
                }
                catch (JMSException jMSException) {}
            }
            if (replyTo != null) {
                try {
                    replyTo.delete();
                }
                catch (JMSException jMSException) {}
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException jMSException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
        return null;
    }
}

