/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum MatchingEntryCountType {
    EXAMINED_COUNT(-128),
    UNEXAMINED_COUNT(-127),
    UPPER_BOUND(-126),
    UNKNOWN(-125);

    private final byte berType;

    private MatchingEntryCountType(byte berType) {
        this.berType = berType;
    }

    public byte getBERType() {
        return this.berType;
    }

    public boolean isMoreSpecificThan(@NotNull MatchingEntryCountType t) {
        switch (this) {
            case EXAMINED_COUNT: {
                return t != EXAMINED_COUNT;
            }
            case UNEXAMINED_COUNT: {
                return t != EXAMINED_COUNT && t != UNEXAMINED_COUNT;
            }
            case UPPER_BOUND: {
                return t != EXAMINED_COUNT && t != UNEXAMINED_COUNT && t != UPPER_BOUND;
            }
        }
        return false;
    }

    public boolean isLessSpecificThan(@NotNull MatchingEntryCountType t) {
        switch (this) {
            case UNKNOWN: {
                return t != UNKNOWN;
            }
            case UPPER_BOUND: {
                return t != UNKNOWN && t != UPPER_BOUND;
            }
            case UNEXAMINED_COUNT: {
                return t != UNKNOWN && t != UPPER_BOUND && t != UNEXAMINED_COUNT;
            }
        }
        return false;
    }

    @Nullable
    public static MatchingEntryCountType valueOf(byte berType) {
        for (MatchingEntryCountType t : MatchingEntryCountType.values()) {
            if (t.berType != berType) continue;
            return t;
        }
        return null;
    }

    @Nullable
    public static MatchingEntryCountType forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "examinedcount": 
            case "examined-count": 
            case "examined_count": {
                return EXAMINED_COUNT;
            }
            case "unexaminedcount": 
            case "unexamined-count": 
            case "unexamined_count": {
                return UNEXAMINED_COUNT;
            }
            case "upperbound": 
            case "upper-bound": 
            case "upper_bound": {
                return UPPER_BOUND;
            }
            case "unknown": {
                return UNKNOWN;
            }
        }
        return null;
    }
}

