/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.Message;
import org.apache.james.mailbox.store.mail.model.impl.Properties;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class SimpleMessage
implements Message {
    private final MessageId messageId;
    private final Content content;
    private final int bodyStartOctet;
    private final Date internalDate;
    private final long size;
    private final Long textualLineCount;
    private final Properties properties;
    private final List<MessageAttachmentMetadata> attachments;

    public SimpleMessage(MessageId messageId, Content content, long size, Date internalDate, int bodyStartOctet, Long textualLineCount, Properties properties, List<MessageAttachmentMetadata> attachments) {
        this.messageId = messageId;
        this.content = content;
        this.bodyStartOctet = bodyStartOctet;
        this.internalDate = internalDate;
        this.size = size;
        this.textualLineCount = textualLineCount;
        this.properties = properties;
        this.attachments = attachments;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public Date getInternalDate() {
        return this.internalDate;
    }

    @Override
    public InputStream getBodyContent() throws IOException {
        InputStream inputStream = this.content.getInputStream();
        inputStream.skip(this.bodyStartOctet);
        return inputStream;
    }

    @Override
    public String getMediaType() {
        return this.properties.getMediaType();
    }

    @Override
    public String getSubType() {
        return this.properties.getSubType();
    }

    @Override
    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.bodyStartOctet;
    }

    @Override
    public long getHeaderOctets() {
        return this.bodyStartOctet;
    }

    @Override
    public long getFullContentOctets() {
        return this.size;
    }

    @Override
    public Long getTextualLineCount() {
        return this.textualLineCount;
    }

    @Override
    public InputStream getHeaderContent() throws IOException {
        return new BoundedInputStream(this.content.getInputStream(), this.headerSize());
    }

    private long headerSize() {
        return Math.max(0, this.bodyStartOctet);
    }

    @Override
    public Optional<byte[][]> getHeadersBytes() {
        try {
            if (this.headerSize() == this.content.size()) {
                return this.content.asBytesSequence();
            }
        }
        catch (MailboxException e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public InputStream getFullContent() throws IOException {
        return this.content.getInputStream();
    }

    @Override
    public Optional<byte[][]> getFullBytes() {
        return this.content.asBytesSequence();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public List<MessageAttachmentMetadata> getAttachments() {
        return this.attachments;
    }

    @Override
    public Publisher<ByteBuffer> getHeaderContentReactive() {
        try {
            if ((long)this.bodyStartOctet >= this.content.size()) {
                return this.content.reactiveBytes();
            }
        }
        catch (MailboxException e) {
            return Flux.error((Throwable)e);
        }
        return Message.super.getHeaderContentReactive();
    }

    @Override
    public Publisher<ByteBuffer> getFullContentReactive() {
        return this.content.reactiveBytes();
    }
}

