/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq.metric;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.util.DurationParser;

public class ActiveMQMetricConfiguration {
    private static final String ENABLED = "metrics.enabled";
    private static final String START_DELAY = "metrics.start_delay";
    private static final String INTERVAL = "metrics.interval";
    private static final String TIMEOUT = "metrics.timeout";
    private static final String AQMP_TIMEOUT = "metrics.aqmp_timeout";
    private static final Duration MINIMAL_START_DELAY = Duration.ofSeconds(1L);
    private static final Duration MINIMAL_INTERVAL = Duration.ofSeconds(5L);
    private static final Duration MINIMAL_TIMEOUT = Duration.ofSeconds(2L);
    private static final Duration MINIMAL_AQMP_TIMEOUT = Duration.ofSeconds(1L);
    private final boolean enabled;
    private final Duration startDelay;
    private final Duration interval;
    private final Duration timeout;
    private final Duration aqmpTimeout;

    public static ActiveMQMetricConfiguration from(Configuration configuration) {
        return new ActiveMQMetricConfiguration(configuration.getBoolean(ENABLED, true), ActiveMQMetricConfiguration.getDurationFromConfiguration(configuration, START_DELAY).orElse(MINIMAL_START_DELAY), ActiveMQMetricConfiguration.getDurationFromConfiguration(configuration, INTERVAL).orElse(MINIMAL_INTERVAL), ActiveMQMetricConfiguration.getDurationFromConfiguration(configuration, TIMEOUT).orElse(MINIMAL_TIMEOUT), ActiveMQMetricConfiguration.getDurationFromConfiguration(configuration, AQMP_TIMEOUT).orElse(MINIMAL_AQMP_TIMEOUT));
    }

    public ActiveMQMetricConfiguration(boolean enabled, Duration startDelay, Duration interval, Duration timeout, Duration aqmpTimeout) {
        this.enabled = enabled;
        this.startDelay = startDelay;
        this.interval = interval;
        this.timeout = timeout;
        this.aqmpTimeout = aqmpTimeout;
        this.checkConfiguration();
    }

    private void checkConfiguration() {
        Preconditions.checkArgument((this.startDelay.compareTo(MINIMAL_START_DELAY) >= 0 ? 1 : 0) != 0, (String)"'%s' must be equal or greater than %d ms", (Object)START_DELAY, (long)MINIMAL_START_DELAY.toMillis());
        Preconditions.checkArgument((this.interval.compareTo(MINIMAL_INTERVAL) >= 0 ? 1 : 0) != 0, (String)"'%s' must be equal or greater than %d ms", (Object)INTERVAL, (long)MINIMAL_INTERVAL.toMillis());
        Preconditions.checkArgument((this.timeout.compareTo(MINIMAL_TIMEOUT) >= 0 ? 1 : 0) != 0, (String)"'%s' must be equal or greater than %d ms", (Object)TIMEOUT, (long)MINIMAL_TIMEOUT.toMillis());
        Preconditions.checkArgument((this.aqmpTimeout.compareTo(MINIMAL_AQMP_TIMEOUT) >= 0 ? 1 : 0) != 0, (String)"'%s' must be equal or greater than %d ms", (Object)AQMP_TIMEOUT, (long)MINIMAL_AQMP_TIMEOUT.toMillis());
        Preconditions.checkArgument((this.interval.compareTo(this.timeout) > 0 ? 1 : 0) != 0, (String)"'%s' must be less than '%s'", (Object)TIMEOUT, (Object)INTERVAL);
        Preconditions.checkArgument((this.timeout.compareTo(this.aqmpTimeout) > 0 ? 1 : 0) != 0, (String)"'%s' must be less than '%s'", (Object)AQMP_TIMEOUT, (Object)TIMEOUT);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Duration getStartDelay() {
        return this.startDelay;
    }

    public Duration getInterval() {
        return this.interval;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public Duration getAqmpTimeout() {
        return this.aqmpTimeout;
    }

    private static Optional<Duration> getDurationFromConfiguration(Configuration configuration, String key) {
        return StringUtils.isEmpty((CharSequence)configuration.getString(key)) ? Optional.empty() : Optional.of(DurationParser.parse((String)configuration.getString(key)));
    }
}

